/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.CollateralAdjust;
import io.gate.gateapi.models.CollateralAdjustRes;
import io.gate.gateapi.models.CollateralCurrentRate;
import io.gate.gateapi.models.CollateralFixRate;
import io.gate.gateapi.models.CollateralLtv;
import io.gate.gateapi.models.CreateMultiCollateralOrder;
import io.gate.gateapi.models.CurrencyQuota;
import io.gate.gateapi.models.MultiCollateralCurrency;
import io.gate.gateapi.models.MultiCollateralOrder;
import io.gate.gateapi.models.MultiCollateralRecord;
import io.gate.gateapi.models.MultiRepayRecord;
import io.gate.gateapi.models.MultiRepayResp;
import io.gate.gateapi.models.OrderResp;
import io.gate.gateapi.models.RepayMultiLoan;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class MultiCollateralLoanApi {
    private ApiClient localVarApiClient;

    public MultiCollateralLoanApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MultiCollateralLoanApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listMultiCollateralOrdersCall(Integer page, Integer limit, String sort, String orderType, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (orderType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_type", orderType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMultiCollateralOrdersValidateBeforeCall(Integer page, Integer limit, String sort, String orderType, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMultiCollateralOrdersCall(page, limit, sort, orderType, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MultiCollateralOrder>> listMultiCollateralOrdersWithHttpInfo(Integer page, Integer limit, String sort, String orderType) throws ApiException {
        Call localVarCall = this.listMultiCollateralOrdersValidateBeforeCall(page, limit, sort, orderType, null);
        Type localVarReturnType = new TypeToken<List<MultiCollateralOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMultiCollateralOrdersAsync(Integer page, Integer limit, String sort, String orderType, ApiCallback<List<MultiCollateralOrder>> _callback) throws ApiException {
        Call localVarCall = this.listMultiCollateralOrdersValidateBeforeCall(page, limit, sort, orderType, _callback);
        Type localVarReturnType = new TypeToken<List<MultiCollateralOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMultiCollateralOrdersRequest listMultiCollateralOrders() {
        return new APIlistMultiCollateralOrdersRequest();
    }

    public Call createMultiCollateralCall(CreateMultiCollateralOrder createMultiCollateralOrder, ApiCallback _callback) throws ApiException {
        CreateMultiCollateralOrder localVarPostBody = createMultiCollateralOrder;
        String localVarPath = "/loan/multi_collateral/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMultiCollateralValidateBeforeCall(CreateMultiCollateralOrder createMultiCollateralOrder, ApiCallback _callback) throws ApiException {
        if (createMultiCollateralOrder == null) {
            throw new ApiException("Missing the required parameter 'createMultiCollateralOrder' when calling createMultiCollateral(Async)");
        }
        Call localVarCall = this.createMultiCollateralCall(createMultiCollateralOrder, _callback);
        return localVarCall;
    }

    public OrderResp createMultiCollateral(CreateMultiCollateralOrder createMultiCollateralOrder) throws ApiException {
        ApiResponse<OrderResp> localVarResp = this.createMultiCollateralWithHttpInfo(createMultiCollateralOrder);
        return localVarResp.getData();
    }

    public ApiResponse<OrderResp> createMultiCollateralWithHttpInfo(CreateMultiCollateralOrder createMultiCollateralOrder) throws ApiException {
        Call localVarCall = this.createMultiCollateralValidateBeforeCall(createMultiCollateralOrder, null);
        Type localVarReturnType = new TypeToken<OrderResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMultiCollateralAsync(CreateMultiCollateralOrder createMultiCollateralOrder, ApiCallback<OrderResp> _callback) throws ApiException {
        Call localVarCall = this.createMultiCollateralValidateBeforeCall(createMultiCollateralOrder, _callback);
        Type localVarReturnType = new TypeToken<OrderResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMultiCollateralOrderDetailCall(String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMultiCollateralOrderDetailValidateBeforeCall(String orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getMultiCollateralOrderDetail(Async)");
        }
        Call localVarCall = this.getMultiCollateralOrderDetailCall(orderId, _callback);
        return localVarCall;
    }

    public MultiCollateralOrder getMultiCollateralOrderDetail(String orderId) throws ApiException {
        ApiResponse<MultiCollateralOrder> localVarResp = this.getMultiCollateralOrderDetailWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<MultiCollateralOrder> getMultiCollateralOrderDetailWithHttpInfo(String orderId) throws ApiException {
        Call localVarCall = this.getMultiCollateralOrderDetailValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<MultiCollateralOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMultiCollateralOrderDetailAsync(String orderId, ApiCallback<MultiCollateralOrder> _callback) throws ApiException {
        Call localVarCall = this.getMultiCollateralOrderDetailValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<MultiCollateralOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listMultiRepayRecordsCall(String type, String borrowCurrency, Integer page, Integer limit, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (borrowCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("borrow_currency", borrowCurrency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMultiRepayRecordsValidateBeforeCall(String type, String borrowCurrency, Integer page, Integer limit, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling listMultiRepayRecords(Async)");
        }
        Call localVarCall = this.listMultiRepayRecordsCall(type, borrowCurrency, page, limit, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MultiRepayRecord>> listMultiRepayRecordsWithHttpInfo(String type, String borrowCurrency, Integer page, Integer limit, Long from, Long to) throws ApiException {
        Call localVarCall = this.listMultiRepayRecordsValidateBeforeCall(type, borrowCurrency, page, limit, from, to, null);
        Type localVarReturnType = new TypeToken<List<MultiRepayRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMultiRepayRecordsAsync(String type, String borrowCurrency, Integer page, Integer limit, Long from, Long to, ApiCallback<List<MultiRepayRecord>> _callback) throws ApiException {
        Call localVarCall = this.listMultiRepayRecordsValidateBeforeCall(type, borrowCurrency, page, limit, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<MultiRepayRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMultiRepayRecordsRequest listMultiRepayRecords(String type) {
        return new APIlistMultiRepayRecordsRequest(type);
    }

    public Call repayMultiCollateralLoanCall(RepayMultiLoan repayMultiLoan, ApiCallback _callback) throws ApiException {
        RepayMultiLoan localVarPostBody = repayMultiLoan;
        String localVarPath = "/loan/multi_collateral/repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call repayMultiCollateralLoanValidateBeforeCall(RepayMultiLoan repayMultiLoan, ApiCallback _callback) throws ApiException {
        if (repayMultiLoan == null) {
            throw new ApiException("Missing the required parameter 'repayMultiLoan' when calling repayMultiCollateralLoan(Async)");
        }
        Call localVarCall = this.repayMultiCollateralLoanCall(repayMultiLoan, _callback);
        return localVarCall;
    }

    public MultiRepayResp repayMultiCollateralLoan(RepayMultiLoan repayMultiLoan) throws ApiException {
        ApiResponse<MultiRepayResp> localVarResp = this.repayMultiCollateralLoanWithHttpInfo(repayMultiLoan);
        return localVarResp.getData();
    }

    public ApiResponse<MultiRepayResp> repayMultiCollateralLoanWithHttpInfo(RepayMultiLoan repayMultiLoan) throws ApiException {
        Call localVarCall = this.repayMultiCollateralLoanValidateBeforeCall(repayMultiLoan, null);
        Type localVarReturnType = new TypeToken<MultiRepayResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call repayMultiCollateralLoanAsync(RepayMultiLoan repayMultiLoan, ApiCallback<MultiRepayResp> _callback) throws ApiException {
        Call localVarCall = this.repayMultiCollateralLoanValidateBeforeCall(repayMultiLoan, _callback);
        Type localVarReturnType = new TypeToken<MultiRepayResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listMultiCollateralRecordsCall(Integer page, Integer limit, Long from, Long to, String collateralCurrency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/mortgage";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (collateralCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("collateral_currency", collateralCurrency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMultiCollateralRecordsValidateBeforeCall(Integer page, Integer limit, Long from, Long to, String collateralCurrency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMultiCollateralRecordsCall(page, limit, from, to, collateralCurrency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MultiCollateralRecord>> listMultiCollateralRecordsWithHttpInfo(Integer page, Integer limit, Long from, Long to, String collateralCurrency) throws ApiException {
        Call localVarCall = this.listMultiCollateralRecordsValidateBeforeCall(page, limit, from, to, collateralCurrency, null);
        Type localVarReturnType = new TypeToken<List<MultiCollateralRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMultiCollateralRecordsAsync(Integer page, Integer limit, Long from, Long to, String collateralCurrency, ApiCallback<List<MultiCollateralRecord>> _callback) throws ApiException {
        Call localVarCall = this.listMultiCollateralRecordsValidateBeforeCall(page, limit, from, to, collateralCurrency, _callback);
        Type localVarReturnType = new TypeToken<List<MultiCollateralRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMultiCollateralRecordsRequest listMultiCollateralRecords() {
        return new APIlistMultiCollateralRecordsRequest();
    }

    public Call operateMultiCollateralCall(CollateralAdjust collateralAdjust, ApiCallback _callback) throws ApiException {
        CollateralAdjust localVarPostBody = collateralAdjust;
        String localVarPath = "/loan/multi_collateral/mortgage";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call operateMultiCollateralValidateBeforeCall(CollateralAdjust collateralAdjust, ApiCallback _callback) throws ApiException {
        if (collateralAdjust == null) {
            throw new ApiException("Missing the required parameter 'collateralAdjust' when calling operateMultiCollateral(Async)");
        }
        Call localVarCall = this.operateMultiCollateralCall(collateralAdjust, _callback);
        return localVarCall;
    }

    public CollateralAdjustRes operateMultiCollateral(CollateralAdjust collateralAdjust) throws ApiException {
        ApiResponse<CollateralAdjustRes> localVarResp = this.operateMultiCollateralWithHttpInfo(collateralAdjust);
        return localVarResp.getData();
    }

    public ApiResponse<CollateralAdjustRes> operateMultiCollateralWithHttpInfo(CollateralAdjust collateralAdjust) throws ApiException {
        Call localVarCall = this.operateMultiCollateralValidateBeforeCall(collateralAdjust, null);
        Type localVarReturnType = new TypeToken<CollateralAdjustRes>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call operateMultiCollateralAsync(CollateralAdjust collateralAdjust, ApiCallback<CollateralAdjustRes> _callback) throws ApiException {
        Call localVarCall = this.operateMultiCollateralValidateBeforeCall(collateralAdjust, _callback);
        Type localVarReturnType = new TypeToken<CollateralAdjustRes>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserCurrencyQuotaCall(String type, String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/currency_quota";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserCurrencyQuotaValidateBeforeCall(String type, String currency, ApiCallback _callback) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling listUserCurrencyQuota(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling listUserCurrencyQuota(Async)");
        }
        Call localVarCall = this.listUserCurrencyQuotaCall(type, currency, _callback);
        return localVarCall;
    }

    public List<CurrencyQuota> listUserCurrencyQuota(String type, String currency) throws ApiException {
        ApiResponse<List<CurrencyQuota>> localVarResp = this.listUserCurrencyQuotaWithHttpInfo(type, currency);
        return localVarResp.getData();
    }

    public ApiResponse<List<CurrencyQuota>> listUserCurrencyQuotaWithHttpInfo(String type, String currency) throws ApiException {
        Call localVarCall = this.listUserCurrencyQuotaValidateBeforeCall(type, currency, null);
        Type localVarReturnType = new TypeToken<List<CurrencyQuota>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUserCurrencyQuotaAsync(String type, String currency, ApiCallback<List<CurrencyQuota>> _callback) throws ApiException {
        Call localVarCall = this.listUserCurrencyQuotaValidateBeforeCall(type, currency, _callback);
        Type localVarReturnType = new TypeToken<List<CurrencyQuota>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listMultiCollateralCurrenciesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMultiCollateralCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMultiCollateralCurrenciesCall(_callback);
        return localVarCall;
    }

    public MultiCollateralCurrency listMultiCollateralCurrencies() throws ApiException {
        ApiResponse<MultiCollateralCurrency> localVarResp = this.listMultiCollateralCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<MultiCollateralCurrency> listMultiCollateralCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listMultiCollateralCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<MultiCollateralCurrency>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listMultiCollateralCurrenciesAsync(ApiCallback<MultiCollateralCurrency> _callback) throws ApiException {
        Call localVarCall = this.listMultiCollateralCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<MultiCollateralCurrency>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMultiCollateralLtvCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/ltv";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMultiCollateralLtvValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getMultiCollateralLtvCall(_callback);
        return localVarCall;
    }

    public CollateralLtv getMultiCollateralLtv() throws ApiException {
        ApiResponse<CollateralLtv> localVarResp = this.getMultiCollateralLtvWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<CollateralLtv> getMultiCollateralLtvWithHttpInfo() throws ApiException {
        Call localVarCall = this.getMultiCollateralLtvValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CollateralLtv>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMultiCollateralLtvAsync(ApiCallback<CollateralLtv> _callback) throws ApiException {
        Call localVarCall = this.getMultiCollateralLtvValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CollateralLtv>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMultiCollateralFixRateCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/fixed_rate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMultiCollateralFixRateValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getMultiCollateralFixRateCall(_callback);
        return localVarCall;
    }

    public List<CollateralFixRate> getMultiCollateralFixRate() throws ApiException {
        ApiResponse<List<CollateralFixRate>> localVarResp = this.getMultiCollateralFixRateWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<CollateralFixRate>> getMultiCollateralFixRateWithHttpInfo() throws ApiException {
        Call localVarCall = this.getMultiCollateralFixRateValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CollateralFixRate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMultiCollateralFixRateAsync(ApiCallback<List<CollateralFixRate>> _callback) throws ApiException {
        Call localVarCall = this.getMultiCollateralFixRateValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CollateralFixRate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getMultiCollateralCurrentRateCall(List<String> currencies, String vipLevel, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/multi_collateral/current_rate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencies != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "currencies", currencies));
        }
        if (vipLevel != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("vip_level", vipLevel));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMultiCollateralCurrentRateValidateBeforeCall(List<String> currencies, String vipLevel, ApiCallback _callback) throws ApiException {
        if (currencies == null) {
            throw new ApiException("Missing the required parameter 'currencies' when calling getMultiCollateralCurrentRate(Async)");
        }
        Call localVarCall = this.getMultiCollateralCurrentRateCall(currencies, vipLevel, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CollateralCurrentRate>> getMultiCollateralCurrentRateWithHttpInfo(List<String> currencies, String vipLevel) throws ApiException {
        Call localVarCall = this.getMultiCollateralCurrentRateValidateBeforeCall(currencies, vipLevel, null);
        Type localVarReturnType = new TypeToken<List<CollateralCurrentRate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMultiCollateralCurrentRateAsync(List<String> currencies, String vipLevel, ApiCallback<List<CollateralCurrentRate>> _callback) throws ApiException {
        Call localVarCall = this.getMultiCollateralCurrentRateValidateBeforeCall(currencies, vipLevel, _callback);
        Type localVarReturnType = new TypeToken<List<CollateralCurrentRate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMultiCollateralCurrentRateRequest getMultiCollateralCurrentRate(List<String> currencies) {
        return new APIgetMultiCollateralCurrentRateRequest(currencies);
    }

    public class APIgetMultiCollateralCurrentRateRequest {
        private final List<String> currencies;
        private String vipLevel;

        private APIgetMultiCollateralCurrentRateRequest(List<String> currencies) {
            this.currencies = currencies;
        }

        public APIgetMultiCollateralCurrentRateRequest vipLevel(String vipLevel) {
            this.vipLevel = vipLevel;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MultiCollateralLoanApi.this.getMultiCollateralCurrentRateCall(this.currencies, this.vipLevel, _callback);
        }

        public List<CollateralCurrentRate> execute() throws ApiException {
            ApiResponse localVarResp = MultiCollateralLoanApi.this.getMultiCollateralCurrentRateWithHttpInfo(this.currencies, this.vipLevel);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CollateralCurrentRate>> executeWithHttpInfo() throws ApiException {
            return MultiCollateralLoanApi.this.getMultiCollateralCurrentRateWithHttpInfo(this.currencies, this.vipLevel);
        }

        public Call executeAsync(ApiCallback<List<CollateralCurrentRate>> _callback) throws ApiException {
            return MultiCollateralLoanApi.this.getMultiCollateralCurrentRateAsync(this.currencies, this.vipLevel, _callback);
        }
    }

    public class APIlistMultiCollateralRecordsRequest {
        private Integer page;
        private Integer limit;
        private Long from;
        private Long to;
        private String collateralCurrency;

        private APIlistMultiCollateralRecordsRequest() {
        }

        public APIlistMultiCollateralRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMultiCollateralRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMultiCollateralRecordsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMultiCollateralRecordsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistMultiCollateralRecordsRequest collateralCurrency(String collateralCurrency) {
            this.collateralCurrency = collateralCurrency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MultiCollateralLoanApi.this.listMultiCollateralRecordsCall(this.page, this.limit, this.from, this.to, this.collateralCurrency, _callback);
        }

        public List<MultiCollateralRecord> execute() throws ApiException {
            ApiResponse localVarResp = MultiCollateralLoanApi.this.listMultiCollateralRecordsWithHttpInfo(this.page, this.limit, this.from, this.to, this.collateralCurrency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MultiCollateralRecord>> executeWithHttpInfo() throws ApiException {
            return MultiCollateralLoanApi.this.listMultiCollateralRecordsWithHttpInfo(this.page, this.limit, this.from, this.to, this.collateralCurrency);
        }

        public Call executeAsync(ApiCallback<List<MultiCollateralRecord>> _callback) throws ApiException {
            return MultiCollateralLoanApi.this.listMultiCollateralRecordsAsync(this.page, this.limit, this.from, this.to, this.collateralCurrency, _callback);
        }
    }

    public class APIlistMultiRepayRecordsRequest {
        private final String type;
        private String borrowCurrency;
        private Integer page;
        private Integer limit;
        private Long from;
        private Long to;

        private APIlistMultiRepayRecordsRequest(String type) {
            this.type = type;
        }

        public APIlistMultiRepayRecordsRequest borrowCurrency(String borrowCurrency) {
            this.borrowCurrency = borrowCurrency;
            return this;
        }

        public APIlistMultiRepayRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMultiRepayRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMultiRepayRecordsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMultiRepayRecordsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MultiCollateralLoanApi.this.listMultiRepayRecordsCall(this.type, this.borrowCurrency, this.page, this.limit, this.from, this.to, _callback);
        }

        public List<MultiRepayRecord> execute() throws ApiException {
            ApiResponse localVarResp = MultiCollateralLoanApi.this.listMultiRepayRecordsWithHttpInfo(this.type, this.borrowCurrency, this.page, this.limit, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MultiRepayRecord>> executeWithHttpInfo() throws ApiException {
            return MultiCollateralLoanApi.this.listMultiRepayRecordsWithHttpInfo(this.type, this.borrowCurrency, this.page, this.limit, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<MultiRepayRecord>> _callback) throws ApiException {
            return MultiCollateralLoanApi.this.listMultiRepayRecordsAsync(this.type, this.borrowCurrency, this.page, this.limit, this.from, this.to, _callback);
        }
    }

    public class APIlistMultiCollateralOrdersRequest {
        private Integer page;
        private Integer limit;
        private String sort;
        private String orderType;

        private APIlistMultiCollateralOrdersRequest() {
        }

        public APIlistMultiCollateralOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMultiCollateralOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMultiCollateralOrdersRequest sort(String sort) {
            this.sort = sort;
            return this;
        }

        public APIlistMultiCollateralOrdersRequest orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MultiCollateralLoanApi.this.listMultiCollateralOrdersCall(this.page, this.limit, this.sort, this.orderType, _callback);
        }

        public List<MultiCollateralOrder> execute() throws ApiException {
            ApiResponse localVarResp = MultiCollateralLoanApi.this.listMultiCollateralOrdersWithHttpInfo(this.page, this.limit, this.sort, this.orderType);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MultiCollateralOrder>> executeWithHttpInfo() throws ApiException {
            return MultiCollateralLoanApi.this.listMultiCollateralOrdersWithHttpInfo(this.page, this.limit, this.sort, this.orderType);
        }

        public Call executeAsync(ApiCallback<List<MultiCollateralOrder>> _callback) throws ApiException {
            return MultiCollateralLoanApi.this.listMultiCollateralOrdersAsync(this.page, this.limit, this.sort, this.orderType, _callback);
        }
    }
}

