/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.CreateUniLoan;
import io.gate.gateapi.models.MaxUniBorrowable;
import io.gate.gateapi.models.UniCurrencyPair;
import io.gate.gateapi.models.UniLoan;
import io.gate.gateapi.models.UniLoanInterestRecord;
import io.gate.gateapi.models.UniLoanRecord;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class MarginUniApi {
    private ApiClient localVarApiClient;

    public MarginUniApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarginUniApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listUniCurrencyPairsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/currency_pairs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniCurrencyPairsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniCurrencyPairsCall(_callback);
        return localVarCall;
    }

    public List<UniCurrencyPair> listUniCurrencyPairs() throws ApiException {
        ApiResponse<List<UniCurrencyPair>> localVarResp = this.listUniCurrencyPairsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<UniCurrencyPair>> listUniCurrencyPairsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listUniCurrencyPairsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<UniCurrencyPair>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUniCurrencyPairsAsync(ApiCallback<List<UniCurrencyPair>> _callback) throws ApiException {
        Call localVarCall = this.listUniCurrencyPairsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<UniCurrencyPair>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUniCurrencyPairCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/currency_pairs/{currency_pair}".replaceAll("\\{currency_pair\\}", this.localVarApiClient.escapeString(currencyPair));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniCurrencyPairValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getUniCurrencyPair(Async)");
        }
        Call localVarCall = this.getUniCurrencyPairCall(currencyPair, _callback);
        return localVarCall;
    }

    public UniCurrencyPair getUniCurrencyPair(String currencyPair) throws ApiException {
        ApiResponse<UniCurrencyPair> localVarResp = this.getUniCurrencyPairWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<UniCurrencyPair> getUniCurrencyPairWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getUniCurrencyPairValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<UniCurrencyPair>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniCurrencyPairAsync(String currencyPair, ApiCallback<UniCurrencyPair> _callback) throws ApiException {
        Call localVarCall = this.getUniCurrencyPairValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<UniCurrencyPair>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarginUniEstimateRateCall(List<String> currencies, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/estimate_rate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencies != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "currencies", currencies));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarginUniEstimateRateValidateBeforeCall(List<String> currencies, ApiCallback _callback) throws ApiException {
        if (currencies == null) {
            throw new ApiException("Missing the required parameter 'currencies' when calling getMarginUniEstimateRate(Async)");
        }
        Call localVarCall = this.getMarginUniEstimateRateCall(currencies, _callback);
        return localVarCall;
    }

    public Map<String, String> getMarginUniEstimateRate(List<String> currencies) throws ApiException {
        ApiResponse<Map<String, String>> localVarResp = this.getMarginUniEstimateRateWithHttpInfo(currencies);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, String>> getMarginUniEstimateRateWithHttpInfo(List<String> currencies) throws ApiException {
        Call localVarCall = this.getMarginUniEstimateRateValidateBeforeCall(currencies, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarginUniEstimateRateAsync(List<String> currencies, ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.getMarginUniEstimateRateValidateBeforeCall(currencies, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listUniLoansCall(String currencyPair, String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniLoansValidateBeforeCall(String currencyPair, String currency, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniLoansCall(currencyPair, currency, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLoan>> listUniLoansWithHttpInfo(String currencyPair, String currency, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listUniLoansValidateBeforeCall(currencyPair, currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoan>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUniLoansAsync(String currencyPair, String currency, Integer page, Integer limit, ApiCallback<List<UniLoan>> _callback) throws ApiException {
        Call localVarCall = this.listUniLoansValidateBeforeCall(currencyPair, currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoan>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUniLoansRequest listUniLoans() {
        return new APIlistUniLoansRequest();
    }

    public Call createUniLoanCall(CreateUniLoan createUniLoan, ApiCallback _callback) throws ApiException {
        CreateUniLoan localVarPostBody = createUniLoan;
        String localVarPath = "/margin/uni/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUniLoanValidateBeforeCall(CreateUniLoan createUniLoan, ApiCallback _callback) throws ApiException {
        if (createUniLoan == null) {
            throw new ApiException("Missing the required parameter 'createUniLoan' when calling createUniLoan(Async)");
        }
        Call localVarCall = this.createUniLoanCall(createUniLoan, _callback);
        return localVarCall;
    }

    public void createUniLoan(CreateUniLoan createUniLoan) throws ApiException {
        this.createUniLoanWithHttpInfo(createUniLoan);
    }

    public ApiResponse<Void> createUniLoanWithHttpInfo(CreateUniLoan createUniLoan) throws ApiException {
        Call localVarCall = this.createUniLoanValidateBeforeCall(createUniLoan, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUniLoanAsync(CreateUniLoan createUniLoan, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUniLoanValidateBeforeCall(createUniLoan, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listUniLoanRecordsCall(String type, String currency, String currencyPair, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/loan_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniLoanRecordsValidateBeforeCall(String type, String currency, String currencyPair, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniLoanRecordsCall(type, currency, currencyPair, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLoanRecord>> listUniLoanRecordsWithHttpInfo(String type, String currency, String currencyPair, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listUniLoanRecordsValidateBeforeCall(type, currency, currencyPair, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoanRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUniLoanRecordsAsync(String type, String currency, String currencyPair, Integer page, Integer limit, ApiCallback<List<UniLoanRecord>> _callback) throws ApiException {
        Call localVarCall = this.listUniLoanRecordsValidateBeforeCall(type, currency, currencyPair, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUniLoanRecordsRequest listUniLoanRecords() {
        return new APIlistUniLoanRecordsRequest();
    }

    private Call listUniLoanInterestRecordsCall(String currencyPair, String currency, Integer page, Integer limit, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/interest_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUniLoanInterestRecordsValidateBeforeCall(String currencyPair, String currency, Integer page, Integer limit, Long from, Long to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listUniLoanInterestRecordsCall(currencyPair, currency, page, limit, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<UniLoanInterestRecord>> listUniLoanInterestRecordsWithHttpInfo(String currencyPair, String currency, Integer page, Integer limit, Long from, Long to) throws ApiException {
        Call localVarCall = this.listUniLoanInterestRecordsValidateBeforeCall(currencyPair, currency, page, limit, from, to, null);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUniLoanInterestRecordsAsync(String currencyPair, String currency, Integer page, Integer limit, Long from, Long to, ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
        Call localVarCall = this.listUniLoanInterestRecordsValidateBeforeCall(currencyPair, currency, page, limit, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUniLoanInterestRecordsRequest listUniLoanInterestRecords() {
        return new APIlistUniLoanInterestRecordsRequest();
    }

    public Call getUniBorrowableCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/uni/borrowable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUniBorrowableValidateBeforeCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUniBorrowable(Async)");
        }
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getUniBorrowable(Async)");
        }
        Call localVarCall = this.getUniBorrowableCall(currency, currencyPair, _callback);
        return localVarCall;
    }

    public MaxUniBorrowable getUniBorrowable(String currency, String currencyPair) throws ApiException {
        ApiResponse<MaxUniBorrowable> localVarResp = this.getUniBorrowableWithHttpInfo(currency, currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<MaxUniBorrowable> getUniBorrowableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        Call localVarCall = this.getUniBorrowableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MaxUniBorrowable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUniBorrowableAsync(String currency, String currencyPair, ApiCallback<MaxUniBorrowable> _callback) throws ApiException {
        Call localVarCall = this.getUniBorrowableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MaxUniBorrowable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUniLoanInterestRecordsRequest {
        private String currencyPair;
        private String currency;
        private Integer page;
        private Integer limit;
        private Long from;
        private Long to;

        private APIlistUniLoanInterestRecordsRequest() {
        }

        public APIlistUniLoanInterestRecordsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistUniLoanInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUniLoanInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUniLoanInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistUniLoanInterestRecordsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistUniLoanInterestRecordsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginUniApi.this.listUniLoanInterestRecordsCall(this.currencyPair, this.currency, this.page, this.limit, this.from, this.to, _callback);
        }

        public List<UniLoanInterestRecord> execute() throws ApiException {
            ApiResponse localVarResp = MarginUniApi.this.listUniLoanInterestRecordsWithHttpInfo(this.currencyPair, this.currency, this.page, this.limit, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLoanInterestRecord>> executeWithHttpInfo() throws ApiException {
            return MarginUniApi.this.listUniLoanInterestRecordsWithHttpInfo(this.currencyPair, this.currency, this.page, this.limit, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
            return MarginUniApi.this.listUniLoanInterestRecordsAsync(this.currencyPair, this.currency, this.page, this.limit, this.from, this.to, _callback);
        }
    }

    public class APIlistUniLoanRecordsRequest {
        private String type;
        private String currency;
        private String currencyPair;
        private Integer page;
        private Integer limit;

        private APIlistUniLoanRecordsRequest() {
        }

        public APIlistUniLoanRecordsRequest type(String type) {
            this.type = type;
            return this;
        }

        public APIlistUniLoanRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUniLoanRecordsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistUniLoanRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUniLoanRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginUniApi.this.listUniLoanRecordsCall(this.type, this.currency, this.currencyPair, this.page, this.limit, _callback);
        }

        public List<UniLoanRecord> execute() throws ApiException {
            ApiResponse localVarResp = MarginUniApi.this.listUniLoanRecordsWithHttpInfo(this.type, this.currency, this.currencyPair, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLoanRecord>> executeWithHttpInfo() throws ApiException {
            return MarginUniApi.this.listUniLoanRecordsWithHttpInfo(this.type, this.currency, this.currencyPair, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<UniLoanRecord>> _callback) throws ApiException {
            return MarginUniApi.this.listUniLoanRecordsAsync(this.type, this.currency, this.currencyPair, this.page, this.limit, _callback);
        }
    }

    public class APIlistUniLoansRequest {
        private String currencyPair;
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUniLoansRequest() {
        }

        public APIlistUniLoansRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistUniLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistUniLoansRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistUniLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginUniApi.this.listUniLoansCall(this.currencyPair, this.currency, this.page, this.limit, _callback);
        }

        public List<UniLoan> execute() throws ApiException {
            ApiResponse localVarResp = MarginUniApi.this.listUniLoansWithHttpInfo(this.currencyPair, this.currency, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<UniLoan>> executeWithHttpInfo() throws ApiException {
            return MarginUniApi.this.listUniLoansWithHttpInfo(this.currencyPair, this.currency, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<UniLoan>> _callback) throws ApiException {
            return MarginUniApi.this.listUniLoansAsync(this.currencyPair, this.currency, this.page, this.limit, _callback);
        }
    }
}

