/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.AutoRepaySetting;
import io.gate.gateapi.models.CrossMarginLoan;
import io.gate.gateapi.models.CrossMarginRepayment;
import io.gate.gateapi.models.FundingAccount;
import io.gate.gateapi.models.MarginAccount;
import io.gate.gateapi.models.MarginAccountBook;
import io.gate.gateapi.models.MarginLeverageTier;
import io.gate.gateapi.models.MarginMarketLeverage;
import io.gate.gateapi.models.MarginTransferable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class MarginApi {
    private ApiClient localVarApiClient;

    public MarginApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarginApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listMarginAccountsCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMarginAccountsValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountsCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MarginAccount>> listMarginAccountsWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.listMarginAccountsValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMarginAccountsAsync(String currencyPair, ApiCallback<List<MarginAccount>> _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountsValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMarginAccountsRequest listMarginAccounts() {
        return new APIlistMarginAccountsRequest();
    }

    private Call listMarginAccountBookCall(String currency, String currencyPair, String type, Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/account_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMarginAccountBookValidateBeforeCall(String currency, String currencyPair, String type, Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountBookCall(currency, currencyPair, type, from, to, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MarginAccountBook>> listMarginAccountBookWithHttpInfo(String currency, String currencyPair, String type, Long from, Long to, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listMarginAccountBookValidateBeforeCall(currency, currencyPair, type, from, to, page, limit, null);
        Type localVarReturnType = new TypeToken<List<MarginAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMarginAccountBookAsync(String currency, String currencyPair, String type, Long from, Long to, Integer page, Integer limit, ApiCallback<List<MarginAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listMarginAccountBookValidateBeforeCall(currency, currencyPair, type, from, to, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMarginAccountBookRequest listMarginAccountBook() {
        return new APIlistMarginAccountBookRequest();
    }

    private Call listFundingAccountsCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/funding_accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFundingAccountsValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listFundingAccountsCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FundingAccount>> listFundingAccountsWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listFundingAccountsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<FundingAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFundingAccountsAsync(String currency, ApiCallback<List<FundingAccount>> _callback) throws ApiException {
        Call localVarCall = this.listFundingAccountsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<FundingAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFundingAccountsRequest listFundingAccounts() {
        return new APIlistFundingAccountsRequest();
    }

    public Call getAutoRepayStatusCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/auto_repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAutoRepayStatusValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAutoRepayStatusCall(_callback);
        return localVarCall;
    }

    public AutoRepaySetting getAutoRepayStatus() throws ApiException {
        ApiResponse<AutoRepaySetting> localVarResp = this.getAutoRepayStatusWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<AutoRepaySetting> getAutoRepayStatusWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAutoRepayStatusValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAutoRepayStatusAsync(ApiCallback<AutoRepaySetting> _callback) throws ApiException {
        Call localVarCall = this.getAutoRepayStatusValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setAutoRepayCall(String status, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/auto_repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setAutoRepayValidateBeforeCall(String status, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling setAutoRepay(Async)");
        }
        Call localVarCall = this.setAutoRepayCall(status, _callback);
        return localVarCall;
    }

    public AutoRepaySetting setAutoRepay(String status) throws ApiException {
        ApiResponse<AutoRepaySetting> localVarResp = this.setAutoRepayWithHttpInfo(status);
        return localVarResp.getData();
    }

    public ApiResponse<AutoRepaySetting> setAutoRepayWithHttpInfo(String status) throws ApiException {
        Call localVarCall = this.setAutoRepayValidateBeforeCall(status, null);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setAutoRepayAsync(String status, ApiCallback<AutoRepaySetting> _callback) throws ApiException {
        Call localVarCall = this.setAutoRepayValidateBeforeCall(status, _callback);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getMarginTransferableCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/transferable";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarginTransferableValidateBeforeCall(String currency, String currencyPair, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getMarginTransferable(Async)");
        }
        Call localVarCall = this.getMarginTransferableCall(currency, currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<MarginTransferable> getMarginTransferableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        Call localVarCall = this.getMarginTransferableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginTransferable>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMarginTransferableAsync(String currency, String currencyPair, ApiCallback<MarginTransferable> _callback) throws ApiException {
        Call localVarCall = this.getMarginTransferableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginTransferable>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMarginTransferableRequest getMarginTransferable(String currency) {
        return new APIgetMarginTransferableRequest(currency);
    }

    public Call getUserMarginTierCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/user/loan_margin_tiers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserMarginTierValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getUserMarginTier(Async)");
        }
        Call localVarCall = this.getUserMarginTierCall(currencyPair, _callback);
        return localVarCall;
    }

    public List<MarginLeverageTier> getUserMarginTier(String currencyPair) throws ApiException {
        ApiResponse<List<MarginLeverageTier>> localVarResp = this.getUserMarginTierWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<List<MarginLeverageTier>> getUserMarginTierWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getUserMarginTierValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<MarginLeverageTier>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserMarginTierAsync(String currencyPair, ApiCallback<List<MarginLeverageTier>> _callback) throws ApiException {
        Call localVarCall = this.getUserMarginTierValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<MarginLeverageTier>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMarketMarginTierCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/loan_margin_tiers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMarketMarginTierValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getMarketMarginTier(Async)");
        }
        Call localVarCall = this.getMarketMarginTierCall(currencyPair, _callback);
        return localVarCall;
    }

    public List<MarginLeverageTier> getMarketMarginTier(String currencyPair) throws ApiException {
        ApiResponse<List<MarginLeverageTier>> localVarResp = this.getMarketMarginTierWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<List<MarginLeverageTier>> getMarketMarginTierWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getMarketMarginTierValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<MarginLeverageTier>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMarketMarginTierAsync(String currencyPair, ApiCallback<List<MarginLeverageTier>> _callback) throws ApiException {
        Call localVarCall = this.getMarketMarginTierValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<MarginLeverageTier>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setUserMarketLeverageCall(MarginMarketLeverage marginMarketLeverage, ApiCallback _callback) throws ApiException {
        MarginMarketLeverage localVarPostBody = marginMarketLeverage;
        String localVarPath = "/margin/leverage/user_market_setting";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setUserMarketLeverageValidateBeforeCall(MarginMarketLeverage marginMarketLeverage, ApiCallback _callback) throws ApiException {
        if (marginMarketLeverage == null) {
            throw new ApiException("Missing the required parameter 'marginMarketLeverage' when calling setUserMarketLeverage(Async)");
        }
        Call localVarCall = this.setUserMarketLeverageCall(marginMarketLeverage, _callback);
        return localVarCall;
    }

    public void setUserMarketLeverage(MarginMarketLeverage marginMarketLeverage) throws ApiException {
        this.setUserMarketLeverageWithHttpInfo(marginMarketLeverage);
    }

    public ApiResponse<Void> setUserMarketLeverageWithHttpInfo(MarginMarketLeverage marginMarketLeverage) throws ApiException {
        Call localVarCall = this.setUserMarketLeverageValidateBeforeCall(marginMarketLeverage, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setUserMarketLeverageAsync(MarginMarketLeverage marginMarketLeverage, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setUserMarketLeverageValidateBeforeCall(marginMarketLeverage, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listMarginUserAccountCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/user/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMarginUserAccountValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listMarginUserAccountCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MarginAccount>> listMarginUserAccountWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.listMarginUserAccountValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMarginUserAccountAsync(String currencyPair, ApiCallback<List<MarginAccount>> _callback) throws ApiException {
        Call localVarCall = this.listMarginUserAccountValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMarginUserAccountRequest listMarginUserAccount() {
        return new APIlistMarginUserAccountRequest();
    }

    private Call listCrossMarginLoansCall(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/loans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call listCrossMarginLoansValidateBeforeCall(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listCrossMarginLoans(Async)");
        }
        Call localVarCall = this.listCrossMarginLoansCall(status, currency, limit, offset, reverse, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CrossMarginLoan>> listCrossMarginLoansWithHttpInfo(Integer status, String currency, Integer limit, Integer offset, Boolean reverse) throws ApiException {
        Call localVarCall = this.listCrossMarginLoansValidateBeforeCall(status, currency, limit, offset, reverse, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCrossMarginLoansAsync(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginLoansValidateBeforeCall(status, currency, limit, offset, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIlistCrossMarginLoansRequest listCrossMarginLoans(Integer status) {
        return new APIlistCrossMarginLoansRequest(status);
    }

    private Call listCrossMarginRepaymentsCall(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/margin/cross/repayments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (loanId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("loan_id", loanId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call listCrossMarginRepaymentsValidateBeforeCall(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginRepaymentsCall(currency, loanId, limit, offset, reverse, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CrossMarginRepayment>> listCrossMarginRepaymentsWithHttpInfo(String currency, String loanId, Integer limit, Integer offset, Boolean reverse) throws ApiException {
        Call localVarCall = this.listCrossMarginRepaymentsValidateBeforeCall(currency, loanId, limit, offset, reverse, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginRepayment>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCrossMarginRepaymentsAsync(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, ApiCallback<List<CrossMarginRepayment>> _callback) throws ApiException {
        Call localVarCall = this.listCrossMarginRepaymentsValidateBeforeCall(currency, loanId, limit, offset, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginRepayment>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIlistCrossMarginRepaymentsRequest listCrossMarginRepayments() {
        return new APIlistCrossMarginRepaymentsRequest();
    }

    public class APIlistCrossMarginRepaymentsRequest {
        private String currency;
        private String loanId;
        private Integer limit;
        private Integer offset;
        private Boolean reverse;

        private APIlistCrossMarginRepaymentsRequest() {
        }

        public APIlistCrossMarginRepaymentsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest loanId(String loanId) {
            this.loanId = loanId;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistCrossMarginRepaymentsRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listCrossMarginRepaymentsCall(this.currency, this.loanId, this.limit, this.offset, this.reverse, _callback);
        }

        @Deprecated
        public List<CrossMarginRepayment> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listCrossMarginRepaymentsWithHttpInfo(this.currency, this.loanId, this.limit, this.offset, this.reverse);
            return (List)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<List<CrossMarginRepayment>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listCrossMarginRepaymentsWithHttpInfo(this.currency, this.loanId, this.limit, this.offset, this.reverse);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<List<CrossMarginRepayment>> _callback) throws ApiException {
            return MarginApi.this.listCrossMarginRepaymentsAsync(this.currency, this.loanId, this.limit, this.offset, this.reverse, _callback);
        }
    }

    public class APIlistCrossMarginLoansRequest {
        private final Integer status;
        private String currency;
        private Integer limit;
        private Integer offset;
        private Boolean reverse;

        private APIlistCrossMarginLoansRequest(Integer status) {
            this.status = status;
        }

        public APIlistCrossMarginLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistCrossMarginLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCrossMarginLoansRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistCrossMarginLoansRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listCrossMarginLoansCall(this.status, this.currency, this.limit, this.offset, this.reverse, _callback);
        }

        @Deprecated
        public List<CrossMarginLoan> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listCrossMarginLoansWithHttpInfo(this.status, this.currency, this.limit, this.offset, this.reverse);
            return (List)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<List<CrossMarginLoan>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listCrossMarginLoansWithHttpInfo(this.status, this.currency, this.limit, this.offset, this.reverse);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
            return MarginApi.this.listCrossMarginLoansAsync(this.status, this.currency, this.limit, this.offset, this.reverse, _callback);
        }
    }

    public class APIlistMarginUserAccountRequest {
        private String currencyPair;

        private APIlistMarginUserAccountRequest() {
        }

        public APIlistMarginUserAccountRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listMarginUserAccountCall(this.currencyPair, _callback);
        }

        public List<MarginAccount> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listMarginUserAccountWithHttpInfo(this.currencyPair);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MarginAccount>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listMarginUserAccountWithHttpInfo(this.currencyPair);
        }

        public Call executeAsync(ApiCallback<List<MarginAccount>> _callback) throws ApiException {
            return MarginApi.this.listMarginUserAccountAsync(this.currencyPair, _callback);
        }
    }

    public class APIgetMarginTransferableRequest {
        private final String currency;
        private String currencyPair;

        private APIgetMarginTransferableRequest(String currency) {
            this.currency = currency;
        }

        public APIgetMarginTransferableRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.getMarginTransferableCall(this.currency, this.currencyPair, _callback);
        }

        public MarginTransferable execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.getMarginTransferableWithHttpInfo(this.currency, this.currencyPair);
            return (MarginTransferable)localVarResp.getData();
        }

        public ApiResponse<MarginTransferable> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.getMarginTransferableWithHttpInfo(this.currency, this.currencyPair);
        }

        public Call executeAsync(ApiCallback<MarginTransferable> _callback) throws ApiException {
            return MarginApi.this.getMarginTransferableAsync(this.currency, this.currencyPair, _callback);
        }
    }

    public class APIlistFundingAccountsRequest {
        private String currency;

        private APIlistFundingAccountsRequest() {
        }

        public APIlistFundingAccountsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listFundingAccountsCall(this.currency, _callback);
        }

        public List<FundingAccount> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listFundingAccountsWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FundingAccount>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listFundingAccountsWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<FundingAccount>> _callback) throws ApiException {
            return MarginApi.this.listFundingAccountsAsync(this.currency, _callback);
        }
    }

    public class APIlistMarginAccountBookRequest {
        private String currency;
        private String currencyPair;
        private String type;
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;

        private APIlistMarginAccountBookRequest() {
        }

        public APIlistMarginAccountBookRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistMarginAccountBookRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public APIlistMarginAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        public APIlistMarginAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistMarginAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistMarginAccountBookRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMarginAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listMarginAccountBookCall(this.currency, this.currencyPair, this.type, this.from, this.to, this.page, this.limit, _callback);
        }

        public List<MarginAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listMarginAccountBookWithHttpInfo(this.currency, this.currencyPair, this.type, this.from, this.to, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MarginAccountBook>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listMarginAccountBookWithHttpInfo(this.currency, this.currencyPair, this.type, this.from, this.to, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<MarginAccountBook>> _callback) throws ApiException {
            return MarginApi.this.listMarginAccountBookAsync(this.currency, this.currencyPair, this.type, this.from, this.to, this.page, this.limit, _callback);
        }
    }

    public class APIlistMarginAccountsRequest {
        private String currencyPair;

        private APIlistMarginAccountsRequest() {
        }

        public APIlistMarginAccountsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return MarginApi.this.listMarginAccountsCall(this.currencyPair, _callback);
        }

        public List<MarginAccount> execute() throws ApiException {
            ApiResponse localVarResp = MarginApi.this.listMarginAccountsWithHttpInfo(this.currencyPair);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MarginAccount>> executeWithHttpInfo() throws ApiException {
            return MarginApi.this.listMarginAccountsWithHttpInfo(this.currencyPair);
        }

        public Call executeAsync(ApiCallback<List<MarginAccount>> _callback) throws ApiException {
            return MarginApi.this.listMarginAccountsAsync(this.currencyPair, _callback);
        }
    }
}

