/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.DualGetOrders;
import io.gate.gateapi.models.DualGetPlans;
import io.gate.gateapi.models.Eth2RateList;
import io.gate.gateapi.models.Eth2Swap;
import io.gate.gateapi.models.FindCoin;
import io.gate.gateapi.models.PlaceDualInvestmentOrder;
import io.gate.gateapi.models.StructuredBuy;
import io.gate.gateapi.models.StructuredGetProjectList;
import io.gate.gateapi.models.StructuredOrderList;
import io.gate.gateapi.models.SwapCoin;
import io.gate.gateapi.models.SwapCoinStruct;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class EarnApi {
    private ApiClient localVarApiClient;

    public EarnApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EarnApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call swapETH2Call(Eth2Swap eth2Swap, ApiCallback _callback) throws ApiException {
        Eth2Swap localVarPostBody = eth2Swap;
        String localVarPath = "/earn/staking/eth2/swap";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call swapETH2ValidateBeforeCall(Eth2Swap eth2Swap, ApiCallback _callback) throws ApiException {
        if (eth2Swap == null) {
            throw new ApiException("Missing the required parameter 'eth2Swap' when calling swapETH2(Async)");
        }
        Call localVarCall = this.swapETH2Call(eth2Swap, _callback);
        return localVarCall;
    }

    public void swapETH2(Eth2Swap eth2Swap) throws ApiException {
        this.swapETH2WithHttpInfo(eth2Swap);
    }

    public ApiResponse<Void> swapETH2WithHttpInfo(Eth2Swap eth2Swap) throws ApiException {
        Call localVarCall = this.swapETH2ValidateBeforeCall(eth2Swap, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call swapETH2Async(Eth2Swap eth2Swap, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.swapETH2ValidateBeforeCall(eth2Swap, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call rateListETH2Call(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/staking/eth2/rate_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rateListETH2ValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.rateListETH2Call(_callback);
        return localVarCall;
    }

    public List<Eth2RateList> rateListETH2() throws ApiException {
        ApiResponse<List<Eth2RateList>> localVarResp = this.rateListETH2WithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Eth2RateList>> rateListETH2WithHttpInfo() throws ApiException {
        Call localVarCall = this.rateListETH2ValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Eth2RateList>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rateListETH2Async(ApiCallback<List<Eth2RateList>> _callback) throws ApiException {
        Call localVarCall = this.rateListETH2ValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Eth2RateList>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listDualInvestmentPlansCall(Long planId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/dual/investment_plan";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (planId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("plan_id", planId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDualInvestmentPlansValidateBeforeCall(Long planId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listDualInvestmentPlansCall(planId, _callback);
        return localVarCall;
    }

    private ApiResponse<List<DualGetPlans>> listDualInvestmentPlansWithHttpInfo(Long planId) throws ApiException {
        Call localVarCall = this.listDualInvestmentPlansValidateBeforeCall(planId, null);
        Type localVarReturnType = new TypeToken<List<DualGetPlans>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDualInvestmentPlansAsync(Long planId, ApiCallback<List<DualGetPlans>> _callback) throws ApiException {
        Call localVarCall = this.listDualInvestmentPlansValidateBeforeCall(planId, _callback);
        Type localVarReturnType = new TypeToken<List<DualGetPlans>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDualInvestmentPlansRequest listDualInvestmentPlans() {
        return new APIlistDualInvestmentPlansRequest();
    }

    private Call listDualOrdersCall(Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/dual/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDualOrdersValidateBeforeCall(Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listDualOrdersCall(from, to, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<DualGetOrders>> listDualOrdersWithHttpInfo(Long from, Long to, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listDualOrdersValidateBeforeCall(from, to, page, limit, null);
        Type localVarReturnType = new TypeToken<List<DualGetOrders>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDualOrdersAsync(Long from, Long to, Integer page, Integer limit, ApiCallback<List<DualGetOrders>> _callback) throws ApiException {
        Call localVarCall = this.listDualOrdersValidateBeforeCall(from, to, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<DualGetOrders>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDualOrdersRequest listDualOrders() {
        return new APIlistDualOrdersRequest();
    }

    public Call placeDualOrderCall(PlaceDualInvestmentOrder placeDualInvestmentOrder, ApiCallback _callback) throws ApiException {
        PlaceDualInvestmentOrder localVarPostBody = placeDualInvestmentOrder;
        String localVarPath = "/earn/dual/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call placeDualOrderValidateBeforeCall(PlaceDualInvestmentOrder placeDualInvestmentOrder, ApiCallback _callback) throws ApiException {
        if (placeDualInvestmentOrder == null) {
            throw new ApiException("Missing the required parameter 'placeDualInvestmentOrder' when calling placeDualOrder(Async)");
        }
        Call localVarCall = this.placeDualOrderCall(placeDualInvestmentOrder, _callback);
        return localVarCall;
    }

    public void placeDualOrder(PlaceDualInvestmentOrder placeDualInvestmentOrder) throws ApiException {
        this.placeDualOrderWithHttpInfo(placeDualInvestmentOrder);
    }

    public ApiResponse<Void> placeDualOrderWithHttpInfo(PlaceDualInvestmentOrder placeDualInvestmentOrder) throws ApiException {
        Call localVarCall = this.placeDualOrderValidateBeforeCall(placeDualInvestmentOrder, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call placeDualOrderAsync(PlaceDualInvestmentOrder placeDualInvestmentOrder, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.placeDualOrderValidateBeforeCall(placeDualInvestmentOrder, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listStructuredProductsCall(String status, String type, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/structured/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listStructuredProductsValidateBeforeCall(String status, String type, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listStructuredProducts(Async)");
        }
        Call localVarCall = this.listStructuredProductsCall(status, type, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<StructuredGetProjectList>> listStructuredProductsWithHttpInfo(String status, String type, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listStructuredProductsValidateBeforeCall(status, type, page, limit, null);
        Type localVarReturnType = new TypeToken<List<StructuredGetProjectList>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listStructuredProductsAsync(String status, String type, Integer page, Integer limit, ApiCallback<List<StructuredGetProjectList>> _callback) throws ApiException {
        Call localVarCall = this.listStructuredProductsValidateBeforeCall(status, type, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<StructuredGetProjectList>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistStructuredProductsRequest listStructuredProducts(String status) {
        return new APIlistStructuredProductsRequest(status);
    }

    private Call listStructuredOrdersCall(Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/earn/structured/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listStructuredOrdersValidateBeforeCall(Long from, Long to, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listStructuredOrdersCall(from, to, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<StructuredOrderList>> listStructuredOrdersWithHttpInfo(Long from, Long to, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listStructuredOrdersValidateBeforeCall(from, to, page, limit, null);
        Type localVarReturnType = new TypeToken<List<StructuredOrderList>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listStructuredOrdersAsync(Long from, Long to, Integer page, Integer limit, ApiCallback<List<StructuredOrderList>> _callback) throws ApiException {
        Call localVarCall = this.listStructuredOrdersValidateBeforeCall(from, to, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<StructuredOrderList>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistStructuredOrdersRequest listStructuredOrders() {
        return new APIlistStructuredOrdersRequest();
    }

    public Call placeStructuredOrderCall(StructuredBuy structuredBuy, ApiCallback _callback) throws ApiException {
        StructuredBuy localVarPostBody = structuredBuy;
        String localVarPath = "/earn/structured/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call placeStructuredOrderValidateBeforeCall(StructuredBuy structuredBuy, ApiCallback _callback) throws ApiException {
        if (structuredBuy == null) {
            throw new ApiException("Missing the required parameter 'structuredBuy' when calling placeStructuredOrder(Async)");
        }
        Call localVarCall = this.placeStructuredOrderCall(structuredBuy, _callback);
        return localVarCall;
    }

    public void placeStructuredOrder(StructuredBuy structuredBuy) throws ApiException {
        this.placeStructuredOrderWithHttpInfo(structuredBuy);
    }

    public ApiResponse<Void> placeStructuredOrderWithHttpInfo(StructuredBuy structuredBuy) throws ApiException {
        Call localVarCall = this.placeStructuredOrderValidateBeforeCall(structuredBuy, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call placeStructuredOrderAsync(StructuredBuy structuredBuy, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.placeStructuredOrderValidateBeforeCall(structuredBuy, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call findCoinCall(FindCoin findCoin, ApiCallback _callback) throws ApiException {
        FindCoin localVarPostBody = findCoin;
        String localVarPath = "/earn/staking/coins";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findCoinValidateBeforeCall(FindCoin findCoin, ApiCallback _callback) throws ApiException {
        if (findCoin == null) {
            throw new ApiException("Missing the required parameter 'findCoin' when calling findCoin(Async)");
        }
        Call localVarCall = this.findCoinCall(findCoin, _callback);
        return localVarCall;
    }

    public Object findCoin(FindCoin findCoin) throws ApiException {
        ApiResponse<Object> localVarResp = this.findCoinWithHttpInfo(findCoin);
        return localVarResp.getData();
    }

    public ApiResponse<Object> findCoinWithHttpInfo(FindCoin findCoin) throws ApiException {
        Call localVarCall = this.findCoinValidateBeforeCall(findCoin, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call findCoinAsync(FindCoin findCoin, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.findCoinValidateBeforeCall(findCoin, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call swapStakingCoinCall(SwapCoin swapCoin, ApiCallback _callback) throws ApiException {
        SwapCoin localVarPostBody = swapCoin;
        String localVarPath = "/earn/staking/swap";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call swapStakingCoinValidateBeforeCall(SwapCoin swapCoin, ApiCallback _callback) throws ApiException {
        if (swapCoin == null) {
            throw new ApiException("Missing the required parameter 'swapCoin' when calling swapStakingCoin(Async)");
        }
        Call localVarCall = this.swapStakingCoinCall(swapCoin, _callback);
        return localVarCall;
    }

    public SwapCoinStruct swapStakingCoin(SwapCoin swapCoin) throws ApiException {
        ApiResponse<SwapCoinStruct> localVarResp = this.swapStakingCoinWithHttpInfo(swapCoin);
        return localVarResp.getData();
    }

    public ApiResponse<SwapCoinStruct> swapStakingCoinWithHttpInfo(SwapCoin swapCoin) throws ApiException {
        Call localVarCall = this.swapStakingCoinValidateBeforeCall(swapCoin, null);
        Type localVarReturnType = new TypeToken<SwapCoinStruct>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call swapStakingCoinAsync(SwapCoin swapCoin, ApiCallback<SwapCoinStruct> _callback) throws ApiException {
        Call localVarCall = this.swapStakingCoinValidateBeforeCall(swapCoin, _callback);
        Type localVarReturnType = new TypeToken<SwapCoinStruct>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistStructuredOrdersRequest {
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;

        private APIlistStructuredOrdersRequest() {
        }

        public APIlistStructuredOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistStructuredOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistStructuredOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistStructuredOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnApi.this.listStructuredOrdersCall(this.from, this.to, this.page, this.limit, _callback);
        }

        public List<StructuredOrderList> execute() throws ApiException {
            ApiResponse localVarResp = EarnApi.this.listStructuredOrdersWithHttpInfo(this.from, this.to, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<StructuredOrderList>> executeWithHttpInfo() throws ApiException {
            return EarnApi.this.listStructuredOrdersWithHttpInfo(this.from, this.to, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<StructuredOrderList>> _callback) throws ApiException {
            return EarnApi.this.listStructuredOrdersAsync(this.from, this.to, this.page, this.limit, _callback);
        }
    }

    public class APIlistStructuredProductsRequest {
        private final String status;
        private String type;
        private Integer page;
        private Integer limit;

        private APIlistStructuredProductsRequest(String status) {
            this.status = status;
        }

        public APIlistStructuredProductsRequest type(String type) {
            this.type = type;
            return this;
        }

        public APIlistStructuredProductsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistStructuredProductsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnApi.this.listStructuredProductsCall(this.status, this.type, this.page, this.limit, _callback);
        }

        public List<StructuredGetProjectList> execute() throws ApiException {
            ApiResponse localVarResp = EarnApi.this.listStructuredProductsWithHttpInfo(this.status, this.type, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<StructuredGetProjectList>> executeWithHttpInfo() throws ApiException {
            return EarnApi.this.listStructuredProductsWithHttpInfo(this.status, this.type, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<StructuredGetProjectList>> _callback) throws ApiException {
            return EarnApi.this.listStructuredProductsAsync(this.status, this.type, this.page, this.limit, _callback);
        }
    }

    public class APIlistDualOrdersRequest {
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;

        private APIlistDualOrdersRequest() {
        }

        public APIlistDualOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistDualOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistDualOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistDualOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnApi.this.listDualOrdersCall(this.from, this.to, this.page, this.limit, _callback);
        }

        public List<DualGetOrders> execute() throws ApiException {
            ApiResponse localVarResp = EarnApi.this.listDualOrdersWithHttpInfo(this.from, this.to, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<DualGetOrders>> executeWithHttpInfo() throws ApiException {
            return EarnApi.this.listDualOrdersWithHttpInfo(this.from, this.to, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<DualGetOrders>> _callback) throws ApiException {
            return EarnApi.this.listDualOrdersAsync(this.from, this.to, this.page, this.limit, _callback);
        }
    }

    public class APIlistDualInvestmentPlansRequest {
        private Long planId;

        private APIlistDualInvestmentPlansRequest() {
        }

        public APIlistDualInvestmentPlansRequest planId(Long planId) {
            this.planId = planId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return EarnApi.this.listDualInvestmentPlansCall(this.planId, _callback);
        }

        public List<DualGetPlans> execute() throws ApiException {
            ApiResponse localVarResp = EarnApi.this.listDualInvestmentPlansWithHttpInfo(this.planId);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<DualGetPlans>> executeWithHttpInfo() throws ApiException {
            return EarnApi.this.listDualInvestmentPlansWithHttpInfo(this.planId);
        }

        public Call executeAsync(ApiCallback<List<DualGetPlans>> _callback) throws ApiException {
            return EarnApi.this.listDualInvestmentPlansAsync(this.planId, _callback);
        }
    }
}

