/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.CollateralAlign;
import io.gate.gateapi.models.CollateralLoanCurrency;
import io.gate.gateapi.models.CollateralOrder;
import io.gate.gateapi.models.CollateralRecord;
import io.gate.gateapi.models.CreateCollateralOrder;
import io.gate.gateapi.models.OrderResp;
import io.gate.gateapi.models.RepayLoan;
import io.gate.gateapi.models.RepayRecord;
import io.gate.gateapi.models.RepayResp;
import io.gate.gateapi.models.UserLtvInfo;
import io.gate.gateapi.models.UserTotalAmount;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class CollateralLoanApi {
    private ApiClient localVarApiClient;

    public CollateralLoanApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CollateralLoanApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listCollateralLoanOrdersCall(Integer page, Integer limit, String collateralCurrency, String borrowCurrency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (collateralCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("collateral_currency", collateralCurrency));
        }
        if (borrowCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("borrow_currency", borrowCurrency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCollateralLoanOrdersValidateBeforeCall(Integer page, Integer limit, String collateralCurrency, String borrowCurrency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCollateralLoanOrdersCall(page, limit, collateralCurrency, borrowCurrency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CollateralOrder>> listCollateralLoanOrdersWithHttpInfo(Integer page, Integer limit, String collateralCurrency, String borrowCurrency) throws ApiException {
        Call localVarCall = this.listCollateralLoanOrdersValidateBeforeCall(page, limit, collateralCurrency, borrowCurrency, null);
        Type localVarReturnType = new TypeToken<List<CollateralOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCollateralLoanOrdersAsync(Integer page, Integer limit, String collateralCurrency, String borrowCurrency, ApiCallback<List<CollateralOrder>> _callback) throws ApiException {
        Call localVarCall = this.listCollateralLoanOrdersValidateBeforeCall(page, limit, collateralCurrency, borrowCurrency, _callback);
        Type localVarReturnType = new TypeToken<List<CollateralOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCollateralLoanOrdersRequest listCollateralLoanOrders() {
        return new APIlistCollateralLoanOrdersRequest();
    }

    public Call createCollateralLoanCall(CreateCollateralOrder createCollateralOrder, ApiCallback _callback) throws ApiException {
        CreateCollateralOrder localVarPostBody = createCollateralOrder;
        String localVarPath = "/loan/collateral/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCollateralLoanValidateBeforeCall(CreateCollateralOrder createCollateralOrder, ApiCallback _callback) throws ApiException {
        if (createCollateralOrder == null) {
            throw new ApiException("Missing the required parameter 'createCollateralOrder' when calling createCollateralLoan(Async)");
        }
        Call localVarCall = this.createCollateralLoanCall(createCollateralOrder, _callback);
        return localVarCall;
    }

    public OrderResp createCollateralLoan(CreateCollateralOrder createCollateralOrder) throws ApiException {
        ApiResponse<OrderResp> localVarResp = this.createCollateralLoanWithHttpInfo(createCollateralOrder);
        return localVarResp.getData();
    }

    public ApiResponse<OrderResp> createCollateralLoanWithHttpInfo(CreateCollateralOrder createCollateralOrder) throws ApiException {
        Call localVarCall = this.createCollateralLoanValidateBeforeCall(createCollateralOrder, null);
        Type localVarReturnType = new TypeToken<OrderResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCollateralLoanAsync(CreateCollateralOrder createCollateralOrder, ApiCallback<OrderResp> _callback) throws ApiException {
        Call localVarCall = this.createCollateralLoanValidateBeforeCall(createCollateralOrder, _callback);
        Type localVarReturnType = new TypeToken<OrderResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCollateralLoanOrderDetailCall(Long orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCollateralLoanOrderDetailValidateBeforeCall(Long orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getCollateralLoanOrderDetail(Async)");
        }
        Call localVarCall = this.getCollateralLoanOrderDetailCall(orderId, _callback);
        return localVarCall;
    }

    public CollateralOrder getCollateralLoanOrderDetail(Long orderId) throws ApiException {
        ApiResponse<CollateralOrder> localVarResp = this.getCollateralLoanOrderDetailWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<CollateralOrder> getCollateralLoanOrderDetailWithHttpInfo(Long orderId) throws ApiException {
        Call localVarCall = this.getCollateralLoanOrderDetailValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<CollateralOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCollateralLoanOrderDetailAsync(Long orderId, ApiCallback<CollateralOrder> _callback) throws ApiException {
        Call localVarCall = this.getCollateralLoanOrderDetailValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<CollateralOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call repayCollateralLoanCall(RepayLoan repayLoan, ApiCallback _callback) throws ApiException {
        RepayLoan localVarPostBody = repayLoan;
        String localVarPath = "/loan/collateral/repay";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call repayCollateralLoanValidateBeforeCall(RepayLoan repayLoan, ApiCallback _callback) throws ApiException {
        if (repayLoan == null) {
            throw new ApiException("Missing the required parameter 'repayLoan' when calling repayCollateralLoan(Async)");
        }
        Call localVarCall = this.repayCollateralLoanCall(repayLoan, _callback);
        return localVarCall;
    }

    public RepayResp repayCollateralLoan(RepayLoan repayLoan) throws ApiException {
        ApiResponse<RepayResp> localVarResp = this.repayCollateralLoanWithHttpInfo(repayLoan);
        return localVarResp.getData();
    }

    public ApiResponse<RepayResp> repayCollateralLoanWithHttpInfo(RepayLoan repayLoan) throws ApiException {
        Call localVarCall = this.repayCollateralLoanValidateBeforeCall(repayLoan, null);
        Type localVarReturnType = new TypeToken<RepayResp>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call repayCollateralLoanAsync(RepayLoan repayLoan, ApiCallback<RepayResp> _callback) throws ApiException {
        Call localVarCall = this.repayCollateralLoanValidateBeforeCall(repayLoan, _callback);
        Type localVarReturnType = new TypeToken<RepayResp>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listRepayRecordsCall(String source, String borrowCurrency, String collateralCurrency, Integer page, Integer limit, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/repay_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (source != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("source", source));
        }
        if (borrowCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("borrow_currency", borrowCurrency));
        }
        if (collateralCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("collateral_currency", collateralCurrency));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRepayRecordsValidateBeforeCall(String source, String borrowCurrency, String collateralCurrency, Integer page, Integer limit, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling listRepayRecords(Async)");
        }
        Call localVarCall = this.listRepayRecordsCall(source, borrowCurrency, collateralCurrency, page, limit, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<RepayRecord>> listRepayRecordsWithHttpInfo(String source, String borrowCurrency, String collateralCurrency, Integer page, Integer limit, Long from, Long to) throws ApiException {
        Call localVarCall = this.listRepayRecordsValidateBeforeCall(source, borrowCurrency, collateralCurrency, page, limit, from, to, null);
        Type localVarReturnType = new TypeToken<List<RepayRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listRepayRecordsAsync(String source, String borrowCurrency, String collateralCurrency, Integer page, Integer limit, Long from, Long to, ApiCallback<List<RepayRecord>> _callback) throws ApiException {
        Call localVarCall = this.listRepayRecordsValidateBeforeCall(source, borrowCurrency, collateralCurrency, page, limit, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<RepayRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRepayRecordsRequest listRepayRecords(String source) {
        return new APIlistRepayRecordsRequest(source);
    }

    private Call listCollateralRecordsCall(Integer page, Integer limit, Long from, Long to, String borrowCurrency, String collateralCurrency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/collaterals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (borrowCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("borrow_currency", borrowCurrency));
        }
        if (collateralCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("collateral_currency", collateralCurrency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCollateralRecordsValidateBeforeCall(Integer page, Integer limit, Long from, Long to, String borrowCurrency, String collateralCurrency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCollateralRecordsCall(page, limit, from, to, borrowCurrency, collateralCurrency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CollateralRecord>> listCollateralRecordsWithHttpInfo(Integer page, Integer limit, Long from, Long to, String borrowCurrency, String collateralCurrency) throws ApiException {
        Call localVarCall = this.listCollateralRecordsValidateBeforeCall(page, limit, from, to, borrowCurrency, collateralCurrency, null);
        Type localVarReturnType = new TypeToken<List<CollateralRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCollateralRecordsAsync(Integer page, Integer limit, Long from, Long to, String borrowCurrency, String collateralCurrency, ApiCallback<List<CollateralRecord>> _callback) throws ApiException {
        Call localVarCall = this.listCollateralRecordsValidateBeforeCall(page, limit, from, to, borrowCurrency, collateralCurrency, _callback);
        Type localVarReturnType = new TypeToken<List<CollateralRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCollateralRecordsRequest listCollateralRecords() {
        return new APIlistCollateralRecordsRequest();
    }

    public Call operateCollateralCall(CollateralAlign collateralAlign, ApiCallback _callback) throws ApiException {
        CollateralAlign localVarPostBody = collateralAlign;
        String localVarPath = "/loan/collateral/collaterals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call operateCollateralValidateBeforeCall(CollateralAlign collateralAlign, ApiCallback _callback) throws ApiException {
        if (collateralAlign == null) {
            throw new ApiException("Missing the required parameter 'collateralAlign' when calling operateCollateral(Async)");
        }
        Call localVarCall = this.operateCollateralCall(collateralAlign, _callback);
        return localVarCall;
    }

    public void operateCollateral(CollateralAlign collateralAlign) throws ApiException {
        this.operateCollateralWithHttpInfo(collateralAlign);
    }

    public ApiResponse<Void> operateCollateralWithHttpInfo(CollateralAlign collateralAlign) throws ApiException {
        Call localVarCall = this.operateCollateralValidateBeforeCall(collateralAlign, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call operateCollateralAsync(CollateralAlign collateralAlign, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.operateCollateralValidateBeforeCall(collateralAlign, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getUserTotalAmountCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/total_amount";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserTotalAmountValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUserTotalAmountCall(_callback);
        return localVarCall;
    }

    public UserTotalAmount getUserTotalAmount() throws ApiException {
        ApiResponse<UserTotalAmount> localVarResp = this.getUserTotalAmountWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<UserTotalAmount> getUserTotalAmountWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUserTotalAmountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UserTotalAmount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserTotalAmountAsync(ApiCallback<UserTotalAmount> _callback) throws ApiException {
        Call localVarCall = this.getUserTotalAmountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UserTotalAmount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserLtvInfoCall(String collateralCurrency, String borrowCurrency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/ltv";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (collateralCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("collateral_currency", collateralCurrency));
        }
        if (borrowCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("borrow_currency", borrowCurrency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserLtvInfoValidateBeforeCall(String collateralCurrency, String borrowCurrency, ApiCallback _callback) throws ApiException {
        if (collateralCurrency == null) {
            throw new ApiException("Missing the required parameter 'collateralCurrency' when calling getUserLtvInfo(Async)");
        }
        if (borrowCurrency == null) {
            throw new ApiException("Missing the required parameter 'borrowCurrency' when calling getUserLtvInfo(Async)");
        }
        Call localVarCall = this.getUserLtvInfoCall(collateralCurrency, borrowCurrency, _callback);
        return localVarCall;
    }

    public UserLtvInfo getUserLtvInfo(String collateralCurrency, String borrowCurrency) throws ApiException {
        ApiResponse<UserLtvInfo> localVarResp = this.getUserLtvInfoWithHttpInfo(collateralCurrency, borrowCurrency);
        return localVarResp.getData();
    }

    public ApiResponse<UserLtvInfo> getUserLtvInfoWithHttpInfo(String collateralCurrency, String borrowCurrency) throws ApiException {
        Call localVarCall = this.getUserLtvInfoValidateBeforeCall(collateralCurrency, borrowCurrency, null);
        Type localVarReturnType = new TypeToken<UserLtvInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserLtvInfoAsync(String collateralCurrency, String borrowCurrency, ApiCallback<UserLtvInfo> _callback) throws ApiException {
        Call localVarCall = this.getUserLtvInfoValidateBeforeCall(collateralCurrency, borrowCurrency, _callback);
        Type localVarReturnType = new TypeToken<UserLtvInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listCollateralCurrenciesCall(String loanCurrency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/loan/collateral/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loanCurrency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("loan_currency", loanCurrency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCollateralCurrenciesValidateBeforeCall(String loanCurrency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCollateralCurrenciesCall(loanCurrency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<CollateralLoanCurrency>> listCollateralCurrenciesWithHttpInfo(String loanCurrency) throws ApiException {
        Call localVarCall = this.listCollateralCurrenciesValidateBeforeCall(loanCurrency, null);
        Type localVarReturnType = new TypeToken<List<CollateralLoanCurrency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCollateralCurrenciesAsync(String loanCurrency, ApiCallback<List<CollateralLoanCurrency>> _callback) throws ApiException {
        Call localVarCall = this.listCollateralCurrenciesValidateBeforeCall(loanCurrency, _callback);
        Type localVarReturnType = new TypeToken<List<CollateralLoanCurrency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCollateralCurrenciesRequest listCollateralCurrencies() {
        return new APIlistCollateralCurrenciesRequest();
    }

    public class APIlistCollateralCurrenciesRequest {
        private String loanCurrency;

        private APIlistCollateralCurrenciesRequest() {
        }

        public APIlistCollateralCurrenciesRequest loanCurrency(String loanCurrency) {
            this.loanCurrency = loanCurrency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CollateralLoanApi.this.listCollateralCurrenciesCall(this.loanCurrency, _callback);
        }

        public List<CollateralLoanCurrency> execute() throws ApiException {
            ApiResponse localVarResp = CollateralLoanApi.this.listCollateralCurrenciesWithHttpInfo(this.loanCurrency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CollateralLoanCurrency>> executeWithHttpInfo() throws ApiException {
            return CollateralLoanApi.this.listCollateralCurrenciesWithHttpInfo(this.loanCurrency);
        }

        public Call executeAsync(ApiCallback<List<CollateralLoanCurrency>> _callback) throws ApiException {
            return CollateralLoanApi.this.listCollateralCurrenciesAsync(this.loanCurrency, _callback);
        }
    }

    public class APIlistCollateralRecordsRequest {
        private Integer page;
        private Integer limit;
        private Long from;
        private Long to;
        private String borrowCurrency;
        private String collateralCurrency;

        private APIlistCollateralRecordsRequest() {
        }

        public APIlistCollateralRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistCollateralRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCollateralRecordsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistCollateralRecordsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistCollateralRecordsRequest borrowCurrency(String borrowCurrency) {
            this.borrowCurrency = borrowCurrency;
            return this;
        }

        public APIlistCollateralRecordsRequest collateralCurrency(String collateralCurrency) {
            this.collateralCurrency = collateralCurrency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CollateralLoanApi.this.listCollateralRecordsCall(this.page, this.limit, this.from, this.to, this.borrowCurrency, this.collateralCurrency, _callback);
        }

        public List<CollateralRecord> execute() throws ApiException {
            ApiResponse localVarResp = CollateralLoanApi.this.listCollateralRecordsWithHttpInfo(this.page, this.limit, this.from, this.to, this.borrowCurrency, this.collateralCurrency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CollateralRecord>> executeWithHttpInfo() throws ApiException {
            return CollateralLoanApi.this.listCollateralRecordsWithHttpInfo(this.page, this.limit, this.from, this.to, this.borrowCurrency, this.collateralCurrency);
        }

        public Call executeAsync(ApiCallback<List<CollateralRecord>> _callback) throws ApiException {
            return CollateralLoanApi.this.listCollateralRecordsAsync(this.page, this.limit, this.from, this.to, this.borrowCurrency, this.collateralCurrency, _callback);
        }
    }

    public class APIlistRepayRecordsRequest {
        private final String source;
        private String borrowCurrency;
        private String collateralCurrency;
        private Integer page;
        private Integer limit;
        private Long from;
        private Long to;

        private APIlistRepayRecordsRequest(String source) {
            this.source = source;
        }

        public APIlistRepayRecordsRequest borrowCurrency(String borrowCurrency) {
            this.borrowCurrency = borrowCurrency;
            return this;
        }

        public APIlistRepayRecordsRequest collateralCurrency(String collateralCurrency) {
            this.collateralCurrency = collateralCurrency;
            return this;
        }

        public APIlistRepayRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistRepayRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistRepayRecordsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistRepayRecordsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CollateralLoanApi.this.listRepayRecordsCall(this.source, this.borrowCurrency, this.collateralCurrency, this.page, this.limit, this.from, this.to, _callback);
        }

        public List<RepayRecord> execute() throws ApiException {
            ApiResponse localVarResp = CollateralLoanApi.this.listRepayRecordsWithHttpInfo(this.source, this.borrowCurrency, this.collateralCurrency, this.page, this.limit, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<RepayRecord>> executeWithHttpInfo() throws ApiException {
            return CollateralLoanApi.this.listRepayRecordsWithHttpInfo(this.source, this.borrowCurrency, this.collateralCurrency, this.page, this.limit, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<RepayRecord>> _callback) throws ApiException {
            return CollateralLoanApi.this.listRepayRecordsAsync(this.source, this.borrowCurrency, this.collateralCurrency, this.page, this.limit, this.from, this.to, _callback);
        }
    }

    public class APIlistCollateralLoanOrdersRequest {
        private Integer page;
        private Integer limit;
        private String collateralCurrency;
        private String borrowCurrency;

        private APIlistCollateralLoanOrdersRequest() {
        }

        public APIlistCollateralLoanOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistCollateralLoanOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCollateralLoanOrdersRequest collateralCurrency(String collateralCurrency) {
            this.collateralCurrency = collateralCurrency;
            return this;
        }

        public APIlistCollateralLoanOrdersRequest borrowCurrency(String borrowCurrency) {
            this.borrowCurrency = borrowCurrency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CollateralLoanApi.this.listCollateralLoanOrdersCall(this.page, this.limit, this.collateralCurrency, this.borrowCurrency, _callback);
        }

        public List<CollateralOrder> execute() throws ApiException {
            ApiResponse localVarResp = CollateralLoanApi.this.listCollateralLoanOrdersWithHttpInfo(this.page, this.limit, this.collateralCurrency, this.borrowCurrency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<CollateralOrder>> executeWithHttpInfo() throws ApiException {
            return CollateralLoanApi.this.listCollateralLoanOrdersWithHttpInfo(this.page, this.limit, this.collateralCurrency, this.borrowCurrency);
        }

        public Call executeAsync(ApiCallback<List<CollateralOrder>> _callback) throws ApiException {
            return CollateralLoanApi.this.listCollateralLoanOrdersAsync(this.page, this.limit, this.collateralCurrency, this.borrowCurrency, _callback);
        }
    }
}

