/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.AccountDetail;
import io.gate.gateapi.models.AccountRateLimit;
import io.gate.gateapi.models.DebitFee;
import io.gate.gateapi.models.StpGroup;
import io.gate.gateapi.models.StpGroupUser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AccountApi {
    private ApiClient localVarApiClient;

    public AccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAccountDetailCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/detail";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountDetailValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAccountDetailCall(_callback);
        return localVarCall;
    }

    public AccountDetail getAccountDetail() throws ApiException {
        ApiResponse<AccountDetail> localVarResp = this.getAccountDetailWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<AccountDetail> getAccountDetailWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAccountDetailValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AccountDetail>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountDetailAsync(ApiCallback<AccountDetail> _callback) throws ApiException {
        Call localVarCall = this.getAccountDetailValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AccountDetail>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountRateLimitCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/rate_limit";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountRateLimitValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAccountRateLimitCall(_callback);
        return localVarCall;
    }

    public List<AccountRateLimit> getAccountRateLimit() throws ApiException {
        ApiResponse<List<AccountRateLimit>> localVarResp = this.getAccountRateLimitWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<AccountRateLimit>> getAccountRateLimitWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAccountRateLimitValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<AccountRateLimit>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountRateLimitAsync(ApiCallback<List<AccountRateLimit>> _callback) throws ApiException {
        Call localVarCall = this.getAccountRateLimitValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<AccountRateLimit>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listSTPGroupsCall(String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/stp_groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSTPGroupsValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSTPGroupsCall(name, _callback);
        return localVarCall;
    }

    private ApiResponse<List<StpGroup>> listSTPGroupsWithHttpInfo(String name) throws ApiException {
        Call localVarCall = this.listSTPGroupsValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<List<StpGroup>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSTPGroupsAsync(String name, ApiCallback<List<StpGroup>> _callback) throws ApiException {
        Call localVarCall = this.listSTPGroupsValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<List<StpGroup>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSTPGroupsRequest listSTPGroups() {
        return new APIlistSTPGroupsRequest();
    }

    public Call createSTPGroupCall(StpGroup stpGroup, ApiCallback _callback) throws ApiException {
        StpGroup localVarPostBody = stpGroup;
        String localVarPath = "/account/stp_groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSTPGroupValidateBeforeCall(StpGroup stpGroup, ApiCallback _callback) throws ApiException {
        if (stpGroup == null) {
            throw new ApiException("Missing the required parameter 'stpGroup' when calling createSTPGroup(Async)");
        }
        Call localVarCall = this.createSTPGroupCall(stpGroup, _callback);
        return localVarCall;
    }

    public StpGroup createSTPGroup(StpGroup stpGroup) throws ApiException {
        ApiResponse<StpGroup> localVarResp = this.createSTPGroupWithHttpInfo(stpGroup);
        return localVarResp.getData();
    }

    public ApiResponse<StpGroup> createSTPGroupWithHttpInfo(StpGroup stpGroup) throws ApiException {
        Call localVarCall = this.createSTPGroupValidateBeforeCall(stpGroup, null);
        Type localVarReturnType = new TypeToken<StpGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSTPGroupAsync(StpGroup stpGroup, ApiCallback<StpGroup> _callback) throws ApiException {
        Call localVarCall = this.createSTPGroupValidateBeforeCall(stpGroup, _callback);
        Type localVarReturnType = new TypeToken<StpGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSTPGroupsUsersCall(Long stpId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/stp_groups/{stp_id}/users".replaceAll("\\{stp_id\\}", this.localVarApiClient.escapeString(stpId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSTPGroupsUsersValidateBeforeCall(Long stpId, ApiCallback _callback) throws ApiException {
        if (stpId == null) {
            throw new ApiException("Missing the required parameter 'stpId' when calling listSTPGroupsUsers(Async)");
        }
        Call localVarCall = this.listSTPGroupsUsersCall(stpId, _callback);
        return localVarCall;
    }

    public List<StpGroupUser> listSTPGroupsUsers(Long stpId) throws ApiException {
        ApiResponse<List<StpGroupUser>> localVarResp = this.listSTPGroupsUsersWithHttpInfo(stpId);
        return localVarResp.getData();
    }

    public ApiResponse<List<StpGroupUser>> listSTPGroupsUsersWithHttpInfo(Long stpId) throws ApiException {
        Call localVarCall = this.listSTPGroupsUsersValidateBeforeCall(stpId, null);
        Type localVarReturnType = new TypeToken<List<StpGroupUser>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSTPGroupsUsersAsync(Long stpId, ApiCallback<List<StpGroupUser>> _callback) throws ApiException {
        Call localVarCall = this.listSTPGroupsUsersValidateBeforeCall(stpId, _callback);
        Type localVarReturnType = new TypeToken<List<StpGroupUser>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call addSTPGroupUsersCall(Long stpId, List<Long> requestBody, ApiCallback _callback) throws ApiException {
        List<Long> localVarPostBody = requestBody;
        String localVarPath = "/account/stp_groups/{stp_id}/users".replaceAll("\\{stp_id\\}", this.localVarApiClient.escapeString(stpId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addSTPGroupUsersValidateBeforeCall(Long stpId, List<Long> requestBody, ApiCallback _callback) throws ApiException {
        if (stpId == null) {
            throw new ApiException("Missing the required parameter 'stpId' when calling addSTPGroupUsers(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling addSTPGroupUsers(Async)");
        }
        Call localVarCall = this.addSTPGroupUsersCall(stpId, requestBody, _callback);
        return localVarCall;
    }

    public List<StpGroupUser> addSTPGroupUsers(Long stpId, List<Long> requestBody) throws ApiException {
        ApiResponse<List<StpGroupUser>> localVarResp = this.addSTPGroupUsersWithHttpInfo(stpId, requestBody);
        return localVarResp.getData();
    }

    public ApiResponse<List<StpGroupUser>> addSTPGroupUsersWithHttpInfo(Long stpId, List<Long> requestBody) throws ApiException {
        Call localVarCall = this.addSTPGroupUsersValidateBeforeCall(stpId, requestBody, null);
        Type localVarReturnType = new TypeToken<List<StpGroupUser>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addSTPGroupUsersAsync(Long stpId, List<Long> requestBody, ApiCallback<List<StpGroupUser>> _callback) throws ApiException {
        Call localVarCall = this.addSTPGroupUsersValidateBeforeCall(stpId, requestBody, _callback);
        Type localVarReturnType = new TypeToken<List<StpGroupUser>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSTPGroupUsersCall(Long stpId, Long userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/stp_groups/{stp_id}/users".replaceAll("\\{stp_id\\}", this.localVarApiClient.escapeString(stpId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSTPGroupUsersValidateBeforeCall(Long stpId, Long userId, ApiCallback _callback) throws ApiException {
        if (stpId == null) {
            throw new ApiException("Missing the required parameter 'stpId' when calling deleteSTPGroupUsers(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteSTPGroupUsers(Async)");
        }
        Call localVarCall = this.deleteSTPGroupUsersCall(stpId, userId, _callback);
        return localVarCall;
    }

    public List<StpGroupUser> deleteSTPGroupUsers(Long stpId, Long userId) throws ApiException {
        ApiResponse<List<StpGroupUser>> localVarResp = this.deleteSTPGroupUsersWithHttpInfo(stpId, userId);
        return localVarResp.getData();
    }

    public ApiResponse<List<StpGroupUser>> deleteSTPGroupUsersWithHttpInfo(Long stpId, Long userId) throws ApiException {
        Call localVarCall = this.deleteSTPGroupUsersValidateBeforeCall(stpId, userId, null);
        Type localVarReturnType = new TypeToken<List<StpGroupUser>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSTPGroupUsersAsync(Long stpId, Long userId, ApiCallback<List<StpGroupUser>> _callback) throws ApiException {
        Call localVarCall = this.deleteSTPGroupUsersValidateBeforeCall(stpId, userId, _callback);
        Type localVarReturnType = new TypeToken<List<StpGroupUser>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDebitFeeCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/debit_fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitFeeValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDebitFeeCall(_callback);
        return localVarCall;
    }

    public DebitFee getDebitFee() throws ApiException {
        ApiResponse<DebitFee> localVarResp = this.getDebitFeeWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<DebitFee> getDebitFeeWithHttpInfo() throws ApiException {
        Call localVarCall = this.getDebitFeeValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<DebitFee>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDebitFeeAsync(ApiCallback<DebitFee> _callback) throws ApiException {
        Call localVarCall = this.getDebitFeeValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<DebitFee>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDebitFeeCall(DebitFee debitFee, ApiCallback _callback) throws ApiException {
        DebitFee localVarPostBody = debitFee;
        String localVarPath = "/account/debit_fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDebitFeeValidateBeforeCall(DebitFee debitFee, ApiCallback _callback) throws ApiException {
        if (debitFee == null) {
            throw new ApiException("Missing the required parameter 'debitFee' when calling setDebitFee(Async)");
        }
        Call localVarCall = this.setDebitFeeCall(debitFee, _callback);
        return localVarCall;
    }

    public void setDebitFee(DebitFee debitFee) throws ApiException {
        this.setDebitFeeWithHttpInfo(debitFee);
    }

    public ApiResponse<Void> setDebitFeeWithHttpInfo(DebitFee debitFee) throws ApiException {
        Call localVarCall = this.setDebitFeeValidateBeforeCall(debitFee, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setDebitFeeAsync(DebitFee debitFee, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setDebitFeeValidateBeforeCall(debitFee, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIlistSTPGroupsRequest {
        private String name;

        private APIlistSTPGroupsRequest() {
        }

        public APIlistSTPGroupsRequest name(String name) {
            this.name = name;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountApi.this.listSTPGroupsCall(this.name, _callback);
        }

        public List<StpGroup> execute() throws ApiException {
            ApiResponse localVarResp = AccountApi.this.listSTPGroupsWithHttpInfo(this.name);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<StpGroup>> executeWithHttpInfo() throws ApiException {
            return AccountApi.this.listSTPGroupsWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<List<StpGroup>> _callback) throws ApiException {
            return AccountApi.this.listSTPGroupsAsync(this.name, _callback);
        }
    }
}

