/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

public class Throughput {
    private long firstReadInstant;
    private long firstWroteInstant;
    private long lastReadInstant;
    private long lastWroteInstant;
    private long numberOfBytesRead;
    private long numberOfBytesWritten;
    private final long readThroughputDelay;
    private final long writeThroughputDelay;

    public Throughput(long readThroughputDelay, long writeThroughputDelay) {
        this.readThroughputDelay = readThroughputDelay;
        this.writeThroughputDelay = writeThroughputDelay;
    }

    public synchronized long lastUsed() {
        if (this.lastReadInstant == 0L && this.lastWroteInstant == 0L) {
            return Long.MAX_VALUE;
        }
        return Math.max(this.lastReadInstant, this.lastWroteInstant);
    }

    public synchronized void read(long numberOfBytes) {
        long now = System.currentTimeMillis();
        if (this.firstReadInstant == 0L) {
            this.firstReadInstant = now;
        }
        this.numberOfBytesRead += numberOfBytes;
        this.lastReadInstant = now;
    }

    public synchronized long readThroughput(long now) {
        if (this.firstReadInstant == 0L || this.numberOfBytesRead == 0L || this.lastReadInstant == this.firstReadInstant) {
            return Long.MAX_VALUE;
        }
        if (this.numberOfBytesWritten == 0L) {
            long millis = now - this.firstReadInstant;
            if (millis < this.readThroughputDelay) {
                return Long.MAX_VALUE;
            }
            double result = (double)this.numberOfBytesRead / (double)millis * 1000.0;
            return Math.round(result);
        }
        double result = (double)this.numberOfBytesRead / (double)(this.lastReadInstant - this.firstReadInstant) * 1000.0;
        return Math.round(result);
    }

    public synchronized long writeThroughput(long now) {
        if (this.firstWroteInstant == 0L || this.numberOfBytesWritten == 0L) {
            return Long.MAX_VALUE;
        }
        long millis = now - this.firstWroteInstant;
        if (millis < this.writeThroughputDelay) {
            return Long.MAX_VALUE;
        }
        double result = (double)this.numberOfBytesWritten / (double)millis * 1000.0;
        return Math.round(result);
    }

    public synchronized void wrote(long numberOfBytes) {
        long now = System.currentTimeMillis();
        if (this.firstWroteInstant == 0L) {
            this.firstWroteInstant = now;
        }
        this.numberOfBytesWritten += numberOfBytes;
        this.lastWroteInstant = now;
    }
}

