/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

import io.fusionauth.http.io.ChunkedOutputStream;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.internal.HTTPBuffers;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class HTTPOutputStream
extends OutputStream {
    private final List<String> acceptEncodings;
    private final HTTPBuffers buffers;
    private final Instrumenter instrumenter;
    private final HTTPResponse response;
    private final ServerToSocketOutputStream serverToSocket;
    private boolean committed;
    private boolean compress;
    private OutputStream delegate;
    private boolean wroteOneByteToClient;

    public HTTPOutputStream(HTTPServerConfiguration configuration, List<String> acceptEncodings, HTTPResponse response, OutputStream delegate, HTTPBuffers buffers, Runnable writeObserver) {
        this.acceptEncodings = acceptEncodings;
        this.response = response;
        this.buffers = buffers;
        this.compress = configuration.isCompressByDefault();
        this.instrumenter = configuration.getInstrumenter();
        this.serverToSocket = new ServerToSocketOutputStream(delegate, buffers, writeObserver);
        this.delegate = this.serverToSocket;
    }

    @Override
    public void close() throws IOException {
        this.commit(true);
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void forceFlush() throws IOException {
        this.commit(false);
        this.delegate.flush();
        this.serverToSocket.forceFlush();
    }

    public boolean isCommitted() {
        return this.wroteOneByteToClient;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        if (this.committed) {
            throw new IllegalStateException("The HTTPResponse compression configuration cannot be modified once bytes have been written to it.");
        }
        this.compress = compress;
    }

    public void reset() {
        if (this.wroteOneByteToClient) {
            throw new IllegalStateException("The HTTPOutputStream can't be reset after it has been committed, meaning at least one byte was written back to the client.");
        }
        this.serverToSocket.reset();
        this.committed = false;
        this.compress = false;
        this.delegate = this.serverToSocket;
    }

    public boolean willCompress() {
        if (this.compress) {
            for (String encoding : this.acceptEncodings) {
                if (encoding.equalsIgnoreCase("gzip")) {
                    return true;
                }
                if (!encoding.equalsIgnoreCase("deflate")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.commit(false);
        this.delegate.write(buffer, offset, length);
        if (this.instrumenter != null) {
            this.instrumenter.wroteToClient(length);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.commit(false);
        this.delegate.write(b);
        if (this.instrumenter != null) {
            this.instrumenter.wroteToClient(1L);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private void commit(boolean closing) throws IOException {
        if (this.committed) {
            return;
        }
        this.committed = true;
        boolean twoOhFour = this.response.getStatus() == 204;
        boolean gzip = false;
        boolean deflate = false;
        boolean chunked = false;
        if (closing && !twoOhFour) {
            this.response.setContentLength(0L);
        } else {
            if (this.compress && !twoOhFour) {
                for (String encoding : this.acceptEncodings) {
                    if (encoding.equalsIgnoreCase("gzip")) {
                        this.response.setHeader("Content-Encoding", "gzip");
                        this.response.setHeader("Vary", "Accept-Encoding");
                        this.response.removeHeader("Content-Length");
                        gzip = true;
                        break;
                    }
                    if (!encoding.equalsIgnoreCase("deflate")) continue;
                    this.response.setHeader("Content-Encoding", "deflate");
                    this.response.setHeader("Vary", "Accept-Encoding");
                    this.response.removeHeader("Content-Length");
                    deflate = true;
                    break;
                }
            }
            if (this.response.getContentLength() == null && !twoOhFour) {
                this.response.setHeader("Transfer-Encoding", "chunked");
                chunked = true;
            }
        }
        HTTPTools.writeResponsePreamble(this.response, this.delegate);
        if (closing || twoOhFour) {
            return;
        }
        if (chunked) {
            this.delegate = new ChunkedOutputStream(this.delegate, this.buffers.chunkBuffer(), this.buffers.chuckedOutputStream());
            if (this.instrumenter != null) {
                this.instrumenter.chunkedResponse();
            }
        }
        if (gzip) {
            try {
                this.delegate = new GZIPOutputStream(this.delegate, true);
                this.response.setHeader("Content-Encoding", "gzip");
                this.response.setHeader("Vary", "Accept-Encoding");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (deflate) {
            this.delegate = new DeflaterOutputStream(this.delegate, true);
        }
    }

    private class ServerToSocketOutputStream
    extends OutputStream {
        private final byte[] buffer;
        private final OutputStream delegate;
        private final byte[] intsAreDumb = new byte[1];
        private final Runnable writeObserver;
        private int bufferIndex;

        public ServerToSocketOutputStream(OutputStream delegate, HTTPBuffers buffers, Runnable writeObserver) {
            this.delegate = delegate;
            this.buffer = buffers.responseBuffer();
            this.bufferIndex = 0;
            this.writeObserver = writeObserver;
        }

        @Override
        public void close() throws IOException {
            this.forceFlush();
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer == null || (double)this.bufferIndex >= (double)this.buffer.length * 0.9) {
                this.forceFlush();
            }
        }

        public void forceFlush() throws IOException {
            if (this.buffer == null || this.bufferIndex == 0) {
                return;
            }
            HTTPOutputStream.this.wroteOneByteToClient = true;
            this.delegate.write(this.buffer, 0, this.bufferIndex);
            this.delegate.flush();
            this.bufferIndex = 0;
        }

        public void reset() {
            this.bufferIndex = 0;
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            this.writeObserver.run();
            if (this.buffer == null) {
                this.delegate.write(b, offset, length);
            } else {
                do {
                    int remaining = this.buffer.length - this.bufferIndex;
                    int toWrite = Math.min(remaining, length);
                    System.arraycopy(b, offset, this.buffer, this.bufferIndex, toWrite);
                    this.bufferIndex += toWrite;
                    offset += toWrite;
                    length -= toWrite;
                    if (this.bufferIndex < this.buffer.length) continue;
                    this.forceFlush();
                } while (length > 0);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.intsAreDumb[0] = (byte)b;
            this.write(this.intsAreDumb, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }
}

