/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

import io.fusionauth.http.io.ChunkedInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.InputStream;

public class HTTPInputStream
extends InputStream {
    private final Instrumenter instrumenter;
    private final Logger logger;
    private final HTTPRequest request;
    private byte[] bodyBytes;
    private int bodyBytesIndex;
    private long bytesRemaining;
    private boolean committed;
    private InputStream delegate;

    public HTTPInputStream(HTTPServerConfiguration configuration, HTTPRequest request, InputStream delegate, byte[] bodyBytes) {
        this.logger = configuration.getLoggerFactory().getLogger(HTTPInputStream.class);
        this.instrumenter = configuration.getInstrumenter();
        this.request = request;
        this.delegate = delegate;
        this.bodyBytes = bodyBytes;
        if (request.getContentLength() != null) {
            this.bytesRemaining = request.getContentLength();
        }
    }

    @Override
    public void close() throws IOException {
    }

    public int purge() throws IOException {
        if (this.bodyBytes != null) {
            this.bytesRemaining -= (long)(this.bodyBytes.length - this.bodyBytesIndex);
        }
        long purged = this.bytesRemaining;
        this.delegate.skipNBytes(this.bytesRemaining);
        this.bytesRemaining = 0L;
        return (int)purged;
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.bytesRemaining <= 0L) {
            return -1;
        }
        if (!this.committed) {
            this.commit();
        }
        if (this.bodyBytes != null) {
            b = this.bodyBytes[this.bodyBytesIndex++];
            if (this.bodyBytesIndex >= this.bodyBytes.length) {
                this.bodyBytes = null;
            }
        } else {
            b = this.delegate.read();
        }
        if (this.instrumenter != null) {
            this.instrumenter.readFromClient(1L);
        }
        --this.bytesRemaining;
        return b;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read;
        if (this.bytesRemaining <= 0L && !this.request.isChunked()) {
            return -1;
        }
        if (!this.committed) {
            this.commit();
        }
        if (this.bodyBytes != null) {
            read = Math.min(this.bodyBytes.length, length);
            System.arraycopy(this.bodyBytes, this.bodyBytesIndex, buffer, offset, read);
            this.bodyBytesIndex += read;
            if (this.bodyBytesIndex >= this.bodyBytes.length) {
                this.bodyBytes = null;
            }
        } else {
            read = this.delegate.read(buffer);
        }
        if (this.instrumenter != null) {
            this.instrumenter.readFromClient(read);
        }
        this.bytesRemaining -= (long)read;
        return read;
    }

    private void commit() {
        boolean hasBody;
        this.committed = true;
        Long contentLength = this.request.getContentLength();
        boolean bl = hasBody = contentLength != null && contentLength > 0L || this.request.isChunked();
        if (!hasBody) {
            this.delegate = InputStream.nullInputStream();
        } else if (contentLength != null) {
            this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using Content-Length header {}.", contentLength);
        } else if (this.request.isChunked()) {
            this.logger.trace("Client indicated it was sending an entity-body in the request. Handling body using chunked encoding.");
            this.delegate = new ChunkedInputStream(this.delegate, 1024, this.bodyBytes);
            this.bodyBytes = null;
            if (this.instrumenter != null) {
                this.instrumenter.chunkedRequest();
            }
        } else {
            this.logger.trace("Client indicated it was NOT sending an entity-body in the request");
        }
    }
}

