/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.internal;

import io.fusionauth.http.ConnectionClosedException;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.internal.HTTPBuffers;
import io.fusionauth.http.server.io.HTTPInputStream;
import io.fusionauth.http.server.io.HTTPOutputStream;
import io.fusionauth.http.server.io.Throughput;
import io.fusionauth.http.server.io.ThroughputInputStream;
import io.fusionauth.http.server.io.ThroughputOutputStream;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class HTTPWorker
implements Runnable {
    private final HTTPBuffers buffers;
    private final HTTPServerConfiguration configuration;
    private final Instrumenter instrumenter;
    private final HTTPListenerConfiguration listener;
    private final Logger logger;
    private final Socket socket;
    private final Throughput throughput;
    private volatile State state;

    public HTTPWorker(Socket socket, HTTPServerConfiguration configuration, Instrumenter instrumenter, HTTPListenerConfiguration listener, Throughput throughput) {
        this.socket = socket;
        this.configuration = configuration;
        this.instrumenter = instrumenter;
        this.listener = listener;
        this.throughput = throughput;
        this.buffers = new HTTPBuffers(configuration);
        this.logger = configuration.getLoggerFactory().getLogger(HTTPWorker.class);
        this.state = State.Read;
        this.logger.debug("Starting HTTP worker virtual thread");
    }

    public Socket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HTTPResponse response = null;
        boolean keepAlive = false;
        try {
            if (this.instrumenter != null) {
                this.instrumenter.threadStarted();
            }
            while (true) {
                this.logger.debug("Running HTTP worker and preparing to read preamble");
                HTTPRequest request = new HTTPRequest(this.configuration.getContextPath(), this.configuration.getMultipartBufferSize(), this.listener.getCertificate() != null ? "https" : "http", this.listener.getPort(), this.socket.getInetAddress().getHostAddress());
                ThroughputInputStream inputStream = new ThroughputInputStream(this.socket.getInputStream(), this.throughput);
                byte[] bodyBytes = HTTPTools.parseRequestPreamble(inputStream, request, this.buffers.requestBuffer(), this.instrumenter, () -> {
                    this.state = State.Read;
                });
                HTTPInputStream httpInputStream = new HTTPInputStream(this.configuration, request, inputStream, bodyBytes);
                request.setInputStream(httpInputStream);
                ThroughputOutputStream throughputOutputStream = new ThroughputOutputStream(this.socket.getOutputStream(), this.throughput);
                response = new HTTPResponse();
                HTTPOutputStream outputStream = new HTTPOutputStream(this.configuration, request.getAcceptEncodings(), response, throughputOutputStream, this.buffers, () -> {
                    this.state = State.Write;
                });
                response.setOutputStream(outputStream);
                String expect = request.getHeader("Expect");
                if (expect != null && expect.equalsIgnoreCase("100-continue")) {
                    this.state = State.Write;
                    if (!this.expectContinue(request)) {
                        this.close(Result.Success, response);
                        return;
                    }
                    this.state = State.Read;
                }
                if (request.isKeepAlive()) {
                    response.setHeader("Connection", "keep-alive");
                    keepAlive = true;
                } else {
                    response.setHeader("Connection", "close");
                    keepAlive = false;
                }
                this.logger.debug("Calling the handler.");
                HTTPHandler handler = this.configuration.getHandler();
                this.state = State.Process;
                handler.handle(request, response);
                response.close();
                this.logger.debug("Handler completed successfully.");
                if (!keepAlive) {
                    this.logger.debug("Closing because no Keep-Alive.");
                    this.close(Result.Success, response);
                    break;
                }
                this.logger.debug("Keeping things alive.");
                this.state = State.KeepAlive;
                this.socket.setSoTimeout((int)this.configuration.getKeepAliveTimeoutDuration().toMillis());
                int purged = httpInputStream.purge();
                this.logger.trace("Purged [{}] bytes.", purged);
            }
        }
        catch (ConnectionClosedException | SocketTimeoutException e) {
            this.close(keepAlive ? Result.Success : Result.Failure, response);
            if (keepAlive) {
                this.logger.debug("Closing because the Keep-Alive expired.", e);
            } else {
                this.logger.debug("Closing because socket timed out.");
            }
        }
        catch (ParseException pe) {
            if (this.instrumenter != null) {
                this.instrumenter.badRequest();
            }
            this.logger.debug("Closing because of a bad request.");
            this.close(Result.Failure, response);
        }
        catch (SocketException e) {
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("Closing because server was shutdown.");
                this.close(Result.Success, response);
            }
        }
        catch (IOException io) {
            this.logger.debug("An IO exception was thrown during processing. These are pretty common.", io);
            this.close(Result.Failure, response);
        }
        catch (Throwable t) {
            this.logger.error("HTTP worker threw an exception while processing a request.", t);
            this.close(Result.Failure, response);
        }
        finally {
            if (this.instrumenter != null) {
                this.instrumenter.threadExited();
            }
        }
    }

    public State state() {
        return this.state;
    }

    private void close(Result result, HTTPResponse response) {
        if (result == Result.Failure && this.instrumenter != null) {
            this.instrumenter.connectionClosed();
        }
        try {
            if (result == Result.Failure && response != null && !response.isCommitted()) {
                response.reset();
                response.setStatus(500);
                response.setContentLength(0L);
                response.close();
            }
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.debug("Could not close the connection because the socket threw an exception.", e);
        }
    }

    private boolean expectContinue(HTTPRequest request) throws IOException {
        HTTPResponse expectResponse = new HTTPResponse();
        ExpectValidator validator = this.configuration.getExpectValidator();
        if (validator != null) {
            validator.validate(request, expectResponse);
        }
        OutputStream out = this.socket.getOutputStream();
        HTTPTools.writeResponsePreamble(expectResponse, out);
        out.flush();
        return expectResponse.getStatus() == 100;
    }

    public static enum State {
        Read,
        Process,
        Write,
        KeepAlive;

    }

    private static enum Result {
        Failure,
        Success;

    }
}

