/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.server.Instrumenter;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadSafeCountingInstrumenter
implements Instrumenter {
    private final AtomicLong badRequests = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong chunkedRequests = new AtomicLong();
    private final AtomicLong chunkedResponses = new AtomicLong();
    private final AtomicLong closedConnections = new AtomicLong();
    private final AtomicLong connections = new AtomicLong();
    private final AtomicLong startedCount = new AtomicLong();
    private final AtomicLong threadCount = new AtomicLong();

    @Override
    public void acceptedConnection() {
        this.connections.incrementAndGet();
    }

    @Override
    public void badRequest() {
        this.badRequests.incrementAndGet();
    }

    @Override
    public void chunkedRequest() {
        this.chunkedRequests.incrementAndGet();
    }

    @Override
    public void chunkedResponse() {
        this.chunkedResponses.incrementAndGet();
    }

    @Override
    public void connectionClosed() {
        this.closedConnections.incrementAndGet();
    }

    public long getBadRequests() {
        return this.badRequests.get();
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    public long getChunkedRequests() {
        return this.chunkedRequests.get();
    }

    public long getChunkedResponses() {
        return this.chunkedResponses.get();
    }

    public long getClosedConnections() {
        return this.closedConnections.get();
    }

    public long getConnections() {
        return this.connections.get();
    }

    public long getStartedCount() {
        return this.startedCount.get();
    }

    public long getThreadCount() {
        return this.threadCount.get();
    }

    @Override
    public void readFromClient(long bytes) {
        this.bytesRead.addAndGet(bytes);
    }

    @Override
    public void serverStarted() {
        this.startedCount.incrementAndGet();
    }

    @Override
    public void threadExited() {
        this.threadCount.decrementAndGet();
    }

    @Override
    public void threadStarted() {
        this.threadCount.incrementAndGet();
    }

    @Override
    public void wroteToClient(long bytes) {
        this.bytesWritten.addAndGet(bytes);
    }
}

