/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.log.SystemOutLoggerFactory;
import io.fusionauth.http.server.Configurable;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HTTPServerConfiguration
implements Configurable<HTTPServerConfiguration> {
    private final List<HTTPListenerConfiguration> listeners = new ArrayList<HTTPListenerConfiguration>();
    private Path baseDir = Path.of("", new String[0]);
    private boolean compressByDefault = true;
    private String contextPath = "";
    private ExpectValidator expectValidator;
    private HTTPHandler handler;
    private Duration initialReadTimeoutDuration = Duration.ofSeconds(2L);
    private Instrumenter instrumenter;
    private Duration keepAliveTimeoutDuration = Duration.ofSeconds(20L);
    private LoggerFactory loggerFactory = SystemOutLoggerFactory.FACTORY;
    private int maxResponseChunkSize = 16384;
    private long minimumReadThroughput = 16384L;
    private long minimumWriteThroughput = 16384L;
    private int multipartBufferSize = 16384;
    private Duration processingTimeoutDuration = Duration.ofSeconds(10L);
    private Duration readThroughputCalculationDelayDuration = Duration.ofSeconds(5L);
    private int requestBufferSize = 16384;
    private int responseBufferSize = 65536;
    private Duration shutdownDuration = Duration.ofSeconds(10L);
    private Duration writeThroughputCalculationDelayDuration = Duration.ofSeconds(5L);

    @Override
    public HTTPServerConfiguration configuration() {
        return this;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ExpectValidator getExpectValidator() {
        return this.expectValidator;
    }

    public HTTPHandler getHandler() {
        return this.handler;
    }

    public Duration getInitialReadTimeoutDuration() {
        return this.initialReadTimeoutDuration;
    }

    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public Duration getKeepAliveTimeoutDuration() {
        return this.keepAliveTimeoutDuration;
    }

    public List<HTTPListenerConfiguration> getListeners() {
        return this.listeners;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public int getMaxResponseChunkSize() {
        return this.maxResponseChunkSize;
    }

    public long getMinimumReadThroughput() {
        return this.minimumReadThroughput;
    }

    public long getMinimumWriteThroughput() {
        return this.minimumWriteThroughput;
    }

    public int getMultipartBufferSize() {
        return this.multipartBufferSize;
    }

    public Duration getProcessingTimeoutDuration() {
        return this.processingTimeoutDuration;
    }

    public Duration getReadThroughputCalculationDelay() {
        return this.readThroughputCalculationDelayDuration;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public Duration getShutdownDuration() {
        return this.shutdownDuration;
    }

    public Duration getWriteThroughputCalculationDelay() {
        return this.writeThroughputCalculationDelayDuration;
    }

    public boolean isCompressByDefault() {
        return this.compressByDefault;
    }

    @Override
    public HTTPServerConfiguration withBaseDir(Path baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    @Override
    public HTTPServerConfiguration withCompressByDefault(boolean compressByDefault) {
        this.compressByDefault = compressByDefault;
        return this;
    }

    @Override
    public HTTPServerConfiguration withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public HTTPServerConfiguration withExpectValidator(ExpectValidator validator) {
        this.expectValidator = validator;
        return this;
    }

    @Override
    public HTTPServerConfiguration withHandler(HTTPHandler handler) {
        Objects.requireNonNull(handler, "You cannot set HTTPHandler to null");
        this.handler = handler;
        return this;
    }

    @Override
    public HTTPServerConfiguration withInitialReadTimeout(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the client timeout to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The client timeout duration must be greater than 0");
        }
        this.initialReadTimeoutDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withInstrumenter(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        return this;
    }

    @Override
    public HTTPServerConfiguration withKeepAliveTimeoutDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the keep-alive timeout duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The keep-alive timeout duration must be grater than 0");
        }
        this.keepAliveTimeoutDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withListener(HTTPListenerConfiguration listener) {
        Objects.requireNonNull(listener, "You cannot set HTTPListenerConfiguration to null");
        this.listeners.add(listener);
        return this;
    }

    @Override
    public HTTPServerConfiguration withLoggerFactory(LoggerFactory loggerFactory) {
        Objects.requireNonNull(loggerFactory, "You cannot set LoggerFactory to null");
        this.loggerFactory = loggerFactory;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMaxResponseChunkSize(int size) {
        this.maxResponseChunkSize = size;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMinimumReadThroughput(long bytesPerSecond) {
        if (bytesPerSecond != -1L && bytesPerSecond < 1024L) {
            throw new IllegalArgumentException("The minimum bytes per second must be greater than 1024. This should probably be faster than a 28.8 baud modem!");
        }
        this.minimumReadThroughput = bytesPerSecond;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMinimumWriteThroughput(long bytesPerSecond) {
        if (bytesPerSecond != -1L && bytesPerSecond < 1024L) {
            throw new IllegalArgumentException("The minimum bytes per second must be greater than 1024. This should probably be faster than a 28.8 baud modem!");
        }
        this.minimumWriteThroughput = bytesPerSecond;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMultipartBufferSize(int multipartBufferSize) {
        if (multipartBufferSize <= 0) {
            throw new IllegalArgumentException("The multi-part buffer size must be greater than 0");
        }
        this.multipartBufferSize = multipartBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withProcessingTimeoutDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the processing timeout duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The processing timeout duration must be grater than 0");
        }
        this.processingTimeoutDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withReadThroughputCalculationDelayDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the read throughput delay duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The read throughput delay duration must be grater than 0");
        }
        this.readThroughputCalculationDelayDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withRequestBufferSize(int requestBufferSize) {
        if (requestBufferSize <= 0) {
            throw new IllegalArgumentException("The request buffer size must be greater than 0");
        }
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withShutdownDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the shutdown duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The shutdown duration must be grater than 0");
        }
        this.shutdownDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withWriteThroughputCalculationDelayDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the write throughput delay duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The write throughput delay duration must be grater than 0");
        }
        this.writeThroughputCalculationDelayDuration = duration;
        return this;
    }
}

