/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

public final class SecurityTools {
    public static final String CERT_END = "-----END CERTIFICATE";
    public static final String CERT_START = "BEGIN CERTIFICATE-----";
    public static final String P8_KEY_END = "-----END PRIVATE KEY";
    public static final String P8_KEY_START = "BEGIN PRIVATE KEY-----";

    private SecurityTools() {
    }

    public static SSLContext clientContext(Certificate certificate) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", certificate);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tmf.getTrustManagers(), null);
        return context;
    }

    public static Certificate parseCertificate(String certificateString) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(certificateString.getBytes());
        return factory.generateCertificates(is).stream().findFirst().get();
    }

    public static Certificate[] parseCertificates(String certificateString) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(certificateString.getBytes());
        Collection<? extends Certificate> certs = factory.generateCertificates(is);
        return SecurityTools.reorderCertificates(certs);
    }

    private static Certificate[] reorderCertificates(Collection<X509Certificate> certs) {
        if (certs.isEmpty()) {
            throw new IllegalArgumentException("Empty certificate list");
        }
        Certificate[] orderedCerts = new X509Certificate[certs.size()];
        if (certs.size() == 1) {
            orderedCerts[0] = certs.stream().findFirst().get();
            return orderedCerts;
        }
        HashMap<X500Principal, X509Certificate> certsByIssuer = new HashMap<X500Principal, X509Certificate>(certs.size());
        HashMap<X500Principal, X509Certificate> certsBySubject = new HashMap<X500Principal, X509Certificate>(certs.size());
        for (X509Certificate cert : certs) {
            certsByIssuer.put(cert.getIssuerX500Principal(), cert);
            certsBySubject.put(cert.getSubjectX500Principal(), cert);
        }
        for (X509Certificate cert : certs) {
            if (certsByIssuer.containsKey(cert.getSubjectX500Principal())) continue;
            orderedCerts[0] = cert;
            break;
        }
        for (int i = 0; i < orderedCerts.length - 1; ++i) {
            X509Certificate issuer = (X509Certificate)certsBySubject.get(((X509Certificate)orderedCerts[i]).getIssuerX500Principal());
            if (issuer == null) {
                throw new IllegalArgumentException("Missing issuer cert for " + String.valueOf(((X509Certificate)orderedCerts[i]).getIssuerX500Principal()));
            }
            orderedCerts[i + 1] = issuer;
        }
        return orderedCerts;
    }

    public static byte[] parseDERFromPEM(String pem, String beginDelimiter, String endDelimiter) {
        int startIndex = pem.indexOf(beginDelimiter);
        if (startIndex < 0) {
            throw new IllegalArgumentException("Invalid PEM format");
        }
        int endIndex = pem.indexOf(endDelimiter);
        if (endIndex < 0) {
            throw new IllegalArgumentException("Invalid PEM format");
        }
        String base64 = pem.substring(startIndex + beginDelimiter.length(), endIndex).replaceAll("\\s", "");
        return Base64.getDecoder().decode(base64);
    }

    public static RSAPrivateKey parsePrivateKey(String privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] keyBytes = SecurityTools.parseDERFromPEM(privateKey, P8_KEY_START, P8_KEY_END);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    public static SSLContext serverContext(Certificate certificate, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", certificate);
        keystore.setKeyEntry("key-alias", privateKey, "changeit".toCharArray(), new Certificate[]{certificate});
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, "changeit".toCharArray());
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(kmf.getKeyManagers(), null, null);
        return context;
    }

    public static SSLContext serverContext(Certificate[] certificateChain, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setKeyEntry("key-alias", privateKey, "changeit".toCharArray(), certificateChain);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, "changeit".toCharArray());
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(kmf.getKeyManagers(), null, null);
        return context;
    }
}

