/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.log;

import io.fusionauth.http.log.BaseLogger;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileLogger
extends BaseLogger {
    private final Writer writer;

    public FileLogger(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            this.writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void handleMessage(String message) {
        try {
            this.writer.write(message + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

