/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buffer;
    protected int count;
    protected int growthRate;

    public FastByteArrayOutputStream(int size, int growthRate) {
        this.buffer = new byte[size];
        this.growthRate = growthRate;
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] bytes() {
        return this.buffer;
    }

    @Override
    public void write(int b) {
        if (this.count + 1 >= this.buffer.length) {
            this.resize(this.growthRate);
        }
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] source, int offset, int length) {
        if (this.count + length >= this.buffer.length) {
            this.resize(Math.max(this.growthRate, length));
        }
        System.arraycopy(source, offset, this.buffer, this.count, length);
        this.count += length;
    }

    @Override
    public void write(byte[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    private void resize(int growth) {
        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + growth);
    }
}

