/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private final byte[] buffer;
    private final FastByteArrayOutputStream chunkOutputStream;
    private final OutputStream delegate;
    private int bufferIndex;
    private boolean closed;

    public ChunkedOutputStream(OutputStream delegate, byte[] buffer, FastByteArrayOutputStream chuckOutputStream) {
        this.delegate = delegate;
        this.buffer = buffer;
        this.chunkOutputStream = chuckOutputStream;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.delegate.write(HTTPValues.ControlBytes.ChunkedTerminator);
            this.delegate.flush();
            this.delegate.close();
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.bufferIndex > 0) {
            String header = Integer.toHexString(this.bufferIndex) + "\r\n";
            this.chunkOutputStream.write(header.getBytes());
            this.chunkOutputStream.write(this.buffer, 0, this.bufferIndex);
            this.chunkOutputStream.write(HTTPValues.ControlBytes.CRLF);
            this.delegate.write(this.chunkOutputStream.bytes(), 0, this.chunkOutputStream.size());
            this.chunkOutputStream.reset();
            this.bufferIndex = 0;
        }
        this.delegate.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        int wrote;
        for (int index = offset; index < length; index += wrote) {
            wrote = Math.min(this.buffer.length - this.bufferIndex, length - index);
            System.arraycopy(b, index, this.buffer, this.bufferIndex, wrote);
            this.bufferIndex += wrote;
            if (this.bufferIndex < this.buffer.length) continue;
            this.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bufferIndex < this.buffer.length) {
            this.buffer[this.bufferIndex++] = (byte)b;
        }
    }
}

