/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.ChunkException;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final byte[] buffer;
    private final InputStream delegate;
    private final StringBuilder headerSizeHex = new StringBuilder();
    private int bufferIndex;
    private int bufferLength;
    private int chunkBytesRemaining;
    private int chunkSize;
    private ChunkedBodyState state = ChunkedBodyState.ChunkSize;

    public ChunkedInputStream(InputStream delegate, int bufferSize, byte[] bodyBytes) {
        this.delegate = delegate;
        if (bodyBytes == null) {
            this.buffer = new byte[bufferSize];
        } else {
            this.bufferLength = bodyBytes.length;
            this.buffer = new byte[Math.max(bufferSize, this.bufferLength)];
            System.arraycopy(bodyBytes, 0, this.buffer, 0, this.bufferLength);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.processChunk(b, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.read(new byte[1]);
    }

    private int processChunk(byte[] destination, int offset, int length) throws IOException {
        if (this.state == ChunkedBodyState.Complete) {
            return -1;
        }
        if (this.bufferIndex >= this.bufferLength) {
            this.bufferIndex = 0;
            this.bufferLength = this.delegate.read(this.buffer);
        }
        while (this.bufferIndex < this.bufferLength) {
            ChunkedBodyState nextState = this.state.next(this.buffer[this.bufferIndex], this.chunkSize, this.chunkSize - this.chunkBytesRemaining);
            if (nextState == ChunkedBodyState.Complete) {
                this.state = nextState;
                ++this.bufferIndex;
                return -1;
            }
            if (nextState == ChunkedBodyState.ChunkSize) {
                this.headerSizeHex.appendCodePoint(this.buffer[this.bufferIndex]);
                this.state = nextState;
            } else if (nextState == ChunkedBodyState.ChunkSizeCR || nextState == ChunkedBodyState.ChunkSizeLF || nextState == ChunkedBodyState.ChunkCR || nextState == ChunkedBodyState.ChunkLF) {
                this.state = nextState;
            } else {
                if (this.state != ChunkedBodyState.Chunk && nextState == ChunkedBodyState.Chunk) {
                    if (this.headerSizeHex.isEmpty()) {
                        throw new ChunkException("Chunk size is missing");
                    }
                    this.chunkBytesRemaining = this.chunkSize = (int)Long.parseLong(this.headerSizeHex, 0, this.headerSizeHex.length(), 16);
                    this.headerSizeHex.delete(0, this.headerSizeHex.length());
                    if (this.chunkSize == 0) {
                        this.state = nextState;
                        return 0;
                    }
                }
                int remainingInBuffer = this.bufferLength - this.bufferIndex;
                int copied = Math.min(Math.min(this.chunkBytesRemaining, remainingInBuffer), length);
                System.arraycopy(this.buffer, this.bufferIndex, destination, offset, copied);
                this.bufferIndex += copied;
                this.chunkBytesRemaining -= copied;
                this.state = nextState;
                return copied;
            }
            ++this.bufferIndex;
        }
        return 0;
    }

    public static enum ChunkedBodyState {
        ChunkSize{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 13) {
                    return ChunkSizeCR;
                }
                if (HTTPTools.isHexadecimalCharacter(ch)) {
                    return ChunkSize;
                }
                throw new ParseException();
            }
        }
        ,
        ChunkSizeCR{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 10) {
                    return ChunkSizeLF;
                }
                throw new ParseException();
            }
        }
        ,
        ChunkSizeLF{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                return Chunk;
            }
        }
        ,
        Chunk{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (bytesRead < length) {
                    return Chunk;
                }
                if (bytesRead == length && ch == 13) {
                    return ChunkCR;
                }
                throw new ParseException();
            }
        }
        ,
        ChunkCR{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (ch == 10) {
                    return length == 0L ? Complete : ChunkLF;
                }
                throw new ParseException();
            }
        }
        ,
        ChunkLF{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                if (length == 0L) {
                    return Complete;
                }
                if (HTTPTools.isHexadecimalCharacter(ch)) {
                    return ChunkSize;
                }
                throw new ParseException();
            }
        }
        ,
        Complete{

            @Override
            public ChunkedBodyState next(byte ch, long length, long bytesRead) {
                return Complete;
            }
        };


        public abstract ChunkedBodyState next(byte var1, long var2, long var4);
    }
}

