/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPool {
    private final ExecutorService executor;
    private final Duration shutdown;

    public ThreadPool(int numberOfThreads, String namePrefix, Duration shutdown) {
        AtomicInteger threadCount = new AtomicInteger(1);
        this.executor = Executors.newFixedThreadPool(numberOfThreads, runnable -> new Thread(runnable, namePrefix + " " + threadCount.getAndIncrement()));
        this.shutdown = shutdown;
    }

    public boolean shutdown() {
        this.executor.shutdownNow();
        try {
            return this.executor.awaitTermination(this.shutdown.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public Future<?> submit(Runnable runnable) {
        return this.executor.submit(runnable);
    }
}

