/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.log.SystemOutLoggerFactory;
import io.fusionauth.http.server.Configurable;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HTTPServerConfiguration
implements Configurable<HTTPServerConfiguration> {
    private final List<HTTPListenerConfiguration> listeners = new ArrayList<HTTPListenerConfiguration>();
    private Path baseDir = Path.of("", new String[0]);
    private Duration clientTimeoutDuration = Duration.ofSeconds(20L);
    private boolean compressByDefault = true;
    private String contextPath = "";
    private ExpectValidator expectValidator;
    private HTTPHandler handler;
    private Instrumenter instrumenter;
    private LoggerFactory loggerFactory = SystemOutLoggerFactory.FACTORY;
    private int maxHeadLength = 131072;
    private int maxOutputBufferQueueLength = 128;
    private long minimumReadThroughput = 16384L;
    private long minimumWriteThroughput = 16384L;
    private int multipartBufferSize = 16384;
    private int numberOfWorkerThreads = 40;
    private int preambleBufferSize = 16384;
    private Duration readThroughputCalculationDelayDuration = Duration.ofSeconds(5L);
    private int requestBufferSize = 16384;
    private int responseBufferSize = 16384;
    private Duration shutdownDuration = Duration.ofSeconds(10L);
    private Duration writeThroughputCalculationDelayDuration = Duration.ofSeconds(5L);

    @Override
    public HTTPServerConfiguration configuration() {
        return this;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Duration getClientTimeoutDuration() {
        return this.clientTimeoutDuration;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ExpectValidator getExpectValidator() {
        return this.expectValidator;
    }

    public HTTPHandler getHandler() {
        return this.handler;
    }

    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public List<HTTPListenerConfiguration> getListeners() {
        return this.listeners;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public int getMaxHeadLength() {
        return this.maxHeadLength;
    }

    public int getMaxOutputBufferQueueLength() {
        return this.maxOutputBufferQueueLength;
    }

    public long getMinimumReadThroughput() {
        return this.minimumReadThroughput;
    }

    public long getMinimumWriteThroughput() {
        return this.minimumWriteThroughput;
    }

    public int getMultipartBufferSize() {
        return this.multipartBufferSize;
    }

    public int getNumberOfWorkerThreads() {
        return this.numberOfWorkerThreads;
    }

    public int getPreambleBufferSize() {
        return this.preambleBufferSize;
    }

    public Duration getReadThroughputCalculationDelay() {
        return this.readThroughputCalculationDelayDuration;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public Duration getShutdownDuration() {
        return this.shutdownDuration;
    }

    public Duration getWriteThroughputCalculationDelay() {
        return this.writeThroughputCalculationDelayDuration;
    }

    public boolean isCompressByDefault() {
        return this.compressByDefault;
    }

    @Override
    public HTTPServerConfiguration withBaseDir(Path baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    @Override
    public HTTPServerConfiguration withClientTimeout(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the client timeout to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The client timeout duration must be greater than 0");
        }
        this.clientTimeoutDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withCompressByDefault(boolean compressByDefault) {
        this.compressByDefault = compressByDefault;
        return this;
    }

    @Override
    public HTTPServerConfiguration withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public HTTPServerConfiguration withExpectValidator(ExpectValidator validator) {
        this.expectValidator = validator;
        return this;
    }

    @Override
    public HTTPServerConfiguration withHandler(HTTPHandler handler) {
        Objects.requireNonNull(handler, "You cannot set HTTPHandler to null");
        this.handler = handler;
        return this;
    }

    @Override
    public HTTPServerConfiguration withInstrumenter(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        return this;
    }

    @Override
    public HTTPServerConfiguration withListener(HTTPListenerConfiguration listener) {
        Objects.requireNonNull(listener, "You cannot set HTTPListenerConfiguration to null");
        this.listeners.add(listener);
        return this;
    }

    @Override
    public HTTPServerConfiguration withLoggerFactory(LoggerFactory loggerFactory) {
        Objects.requireNonNull(loggerFactory, "You cannot set LoggerFactory to null");
        this.loggerFactory = loggerFactory;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMaxOutputBufferQueueLength(int outputBufferQueueLength) {
        if (outputBufferQueueLength < 16) {
            throw new IllegalArgumentException("The maximum output buffer queue length must be greater than or equal to 16");
        }
        this.maxOutputBufferQueueLength = outputBufferQueueLength;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMaxPreambleLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("The maximum preamble length must be greater than 0");
        }
        this.maxHeadLength = maxLength;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMinimumReadThroughput(long bytesPerSecond) {
        if (bytesPerSecond < 1024L) {
            throw new IllegalArgumentException("The minimum bytes per second must be greater than 1024. This should probably be faster than a 28.8 baud modem!");
        }
        this.minimumReadThroughput = bytesPerSecond;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMinimumWriteThroughput(long bytesPerSecond) {
        if (bytesPerSecond < 1024L) {
            throw new IllegalArgumentException("The minimum bytes per second must be greater than 1024. This should probably be faster than a 28.8 baud modem!");
        }
        this.minimumWriteThroughput = bytesPerSecond;
        return this;
    }

    @Override
    public HTTPServerConfiguration withMultipartBufferSize(int multipartBufferSize) {
        if (multipartBufferSize <= 0) {
            throw new IllegalArgumentException("The multi-part buffer size must be greater than 0");
        }
        this.multipartBufferSize = multipartBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withNumberOfWorkerThreads(int numberOfWorkerThreads) {
        if (numberOfWorkerThreads <= 0) {
            throw new IllegalArgumentException("The number of worker threads must be greater than 0");
        }
        this.numberOfWorkerThreads = numberOfWorkerThreads;
        return this;
    }

    @Override
    public HTTPServerConfiguration withPreambleBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The preamble buffer size must be greater than 0");
        }
        this.preambleBufferSize = size;
        return this;
    }

    @Override
    public HTTPServerConfiguration withReadThroughputCalculationDelayDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the read throughput delay duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The read throughput delay duration must be grater than 0");
        }
        this.readThroughputCalculationDelayDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withRequestBufferSize(int requestBufferSize) {
        if (requestBufferSize <= 0) {
            throw new IllegalArgumentException("The request buffer size must be greater than 0");
        }
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withResponseBufferSize(int responseBufferSize) {
        if (responseBufferSize <= 0) {
            throw new IllegalArgumentException("The response buffer size must be greater than 0");
        }
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    @Override
    public HTTPServerConfiguration withShutdownDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the shutdown duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The shutdown duration must be grater than 0");
        }
        this.shutdownDuration = duration;
        return this;
    }

    @Override
    public HTTPServerConfiguration withWriteThroughputCalculationDelayDuration(Duration duration) {
        Objects.requireNonNull(duration, "You cannot set the write throughput delay duration to null");
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("The write throughput delay duration must be grater than 0");
        }
        this.writeThroughputCalculationDelayDuration = duration;
        return this;
    }
}

