/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.body.response.BodyProcessor;
import io.fusionauth.http.body.response.ChunkedBodyProcessor;
import io.fusionauth.http.body.response.ContentLengthBodyProcessor;
import io.fusionauth.http.body.response.EmptyBodyProcessor;
import io.fusionauth.http.io.BlockingByteBufferOutputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPRequestProcessor;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.ResponseState;
import io.fusionauth.http.util.HTTPTools;
import java.nio.ByteBuffer;

public class HTTPResponseProcessor {
    private final HTTPServerConfiguration configuration;
    private final Logger logger;
    private final BlockingByteBufferOutputStream outputStream;
    private final HTTPRequest request;
    private final HTTPResponse response;
    private BodyProcessor bodyProcessor;
    private ByteBuffer[] preambleBuffers;
    private volatile ResponseState state = ResponseState.Preamble;

    public HTTPResponseProcessor(HTTPServerConfiguration configuration, HTTPRequest request, HTTPResponse response, BlockingByteBufferOutputStream outputStream) {
        this.configuration = configuration;
        this.request = request;
        this.response = response;
        this.outputStream = outputStream;
        this.logger = configuration.getLoggerFactory().getLogger(HTTPRequestProcessor.class);
    }

    public synchronized ByteBuffer[] currentBuffer() {
        if (this.state == ResponseState.Preamble || this.state == ResponseState.Expect) {
            if (this.state != ResponseState.Expect && !this.outputStream.hasReadableBuffer() && !this.outputStream.isClosed()) {
                return null;
            }
            if (this.preambleBuffers == null) {
                Long contentLength;
                this.logger.debug("The server (via a worker thread or the server due to an Expect request) has bytes to write or has closed the stream, but the preamble hasn't been sent yet. Generating preamble");
                int maxHeadLength = this.configuration.getMaxHeadLength();
                if (this.state == ResponseState.Preamble) {
                    this.fillInHeaders();
                    this.preambleBuffers = new ByteBuffer[]{HTTPTools.buildResponsePreamble(this.response, maxHeadLength)};
                } else if (this.state == ResponseState.Expect) {
                    this.preambleBuffers = new ByteBuffer[]{HTTPTools.buildExpectResponsePreamble(this.response, maxHeadLength)};
                }
                this.logger.debug("Preamble is [{}] bytes long", this.preambleBuffers[0].remaining());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Preamble is [\n{}\n]", new String(this.preambleBuffers[0].array(), 0, this.preambleBuffers[0].remaining()));
                }
                if ((contentLength = this.response.getContentLength()) != null && contentLength > 0L) {
                    this.bodyProcessor = new ContentLengthBodyProcessor(this.outputStream);
                } else if (!this.outputStream.isEmpty()) {
                    this.bodyProcessor = new ChunkedBodyProcessor(this.outputStream);
                    Instrumenter instrumenter = this.configuration.getInstrumenter();
                    if (instrumenter != null) {
                        instrumenter.chunkedResponse();
                    }
                } else {
                    this.bodyProcessor = new EmptyBodyProcessor();
                }
            }
            if (this.preambleBuffers[0].hasRemaining()) {
                this.logger.debug("Still writing preamble");
                return this.preambleBuffers;
            }
            this.preambleBuffers = null;
            if (this.state == ResponseState.Expect) {
                this.logger.debug("Expect response written");
                if (this.response.getStatus() == 100) {
                    this.logger.debug("Continuing");
                    this.state = ResponseState.Continue;
                } else {
                    this.logger.debug("Closing");
                    this.state = ResponseState.Close;
                }
            } else {
                this.state = ResponseState.Body;
            }
        } else if (this.state == ResponseState.Body) {
            ByteBuffer[] buffer = this.bodyProcessor.currentBuffers();
            if (buffer != null) {
                this.logger.debug("Writing back bytes");
                return buffer;
            }
            boolean complete = this.bodyProcessor.isComplete();
            if (complete) {
                this.state = this.response.isKeepAlive() ? ResponseState.KeepAlive : ResponseState.Close;
                this.logger.debug("No more bytes from worker thread. Changing state to [{}]", new Object[]{this.state});
            } else {
                this.logger.debug("Nothing to write from the worker thread but the OutputStream isn't closed");
            }
        }
        return null;
    }

    public synchronized void failure() {
        this.response.setStatus(500);
        this.response.setStatusMessage("Failure");
        this.response.clearHeaders();
        this.response.setContentLength(0L);
        this.preambleBuffers = null;
        this.outputStream.clear();
        this.outputStream.close();
        this.state = ResponseState.Preamble;
    }

    public void resetState(ResponseState state) {
        this.state = state;
    }

    public ResponseState state() {
        return this.state;
    }

    private void fillInHeaders() {
        Long contentLength;
        String requestConnection = this.request.getHeader("Connection");
        boolean requestKeepAlive = "keep-alive".equalsIgnoreCase(requestConnection);
        String responseConnection = this.response.getHeader("Connection");
        boolean responseKeepAlive = "keep-alive".equalsIgnoreCase(responseConnection);
        if ("close".equalsIgnoreCase(requestConnection)) {
            this.response.setHeader("Connection", "close");
        } else if (requestKeepAlive && responseKeepAlive || requestKeepAlive && responseConnection == null || requestConnection == null && responseConnection == null) {
            this.response.setHeader("Connection", "keep-alive");
        }
        if (this.response.getContentLength() != null && this.response.willCompress()) {
            this.response.removeHeader("Content-Length");
        }
        if ((contentLength = this.response.getContentLength()) == null && this.outputStream.isEmpty()) {
            this.response.setContentLength(0L);
        } else if (contentLength == null) {
            this.response.setHeader("Transfer-Encoding", "chunked");
        }
        for (Cookie cookie : this.response.getCookies()) {
            String value = cookie.toResponseHeader();
            this.response.addHeader("Set-Cookie", value);
        }
    }
}

