/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.security.SecurityTools;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class HTTPListenerConfiguration {
    private final InetAddress bindAddress;
    private final Certificate[] certificateChain;
    private final int port;
    private final PrivateKey privateKey;
    private final boolean tls;

    public HTTPListenerConfiguration(int port) {
        this.bindAddress = this.allInterfaces();
        this.port = port;
        this.tls = false;
        this.certificateChain = null;
        this.privateKey = null;
    }

    public HTTPListenerConfiguration(int port, String certificate, String privateKey) throws GeneralSecurityException {
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(privateKey);
        this.bindAddress = this.allInterfaces();
        this.port = port;
        this.tls = true;
        this.certificateChain = SecurityTools.parseCertificates(certificate);
        this.privateKey = SecurityTools.parsePrivateKey(privateKey);
    }

    public HTTPListenerConfiguration(int port, Certificate certificate, PrivateKey privateKey) {
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(privateKey);
        this.bindAddress = this.allInterfaces();
        this.port = port;
        this.tls = true;
        this.certificateChain = new Certificate[]{certificate};
        this.privateKey = privateKey;
    }

    public HTTPListenerConfiguration(int port, Certificate[] certificateChain, PrivateKey privateKey) {
        Objects.requireNonNull(certificateChain);
        Objects.requireNonNull(privateKey);
        this.bindAddress = this.allInterfaces();
        this.port = port;
        this.tls = true;
        this.certificateChain = certificateChain;
        this.privateKey = privateKey;
    }

    public HTTPListenerConfiguration(InetAddress bindAddress, int port) {
        Objects.requireNonNull(bindAddress);
        this.bindAddress = bindAddress;
        this.port = port;
        this.tls = false;
        this.certificateChain = null;
        this.privateKey = null;
    }

    public HTTPListenerConfiguration(InetAddress bindAddress, int port, String certificate, String privateKey) throws GeneralSecurityException {
        Objects.requireNonNull(bindAddress);
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(privateKey);
        this.bindAddress = bindAddress;
        this.port = port;
        this.tls = true;
        this.certificateChain = SecurityTools.parseCertificates(certificate);
        this.privateKey = SecurityTools.parsePrivateKey(privateKey);
    }

    public HTTPListenerConfiguration(InetAddress bindAddress, int port, Certificate certificate, PrivateKey privateKey) {
        Objects.requireNonNull(bindAddress);
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(privateKey);
        this.bindAddress = bindAddress;
        this.port = port;
        this.tls = true;
        this.certificateChain = new Certificate[]{certificate};
        this.privateKey = privateKey;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public Certificate getCertificate() {
        if (this.certificateChain != null && this.certificateChain.length > 0) {
            return this.certificateChain[0];
        }
        return null;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public int getPort() {
        return this.port;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean isTLS() {
        return this.tls;
    }

    private InetAddress allInterfaces() {
        try {
            boolean ipv6Supported = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().map(NetworkInterface::getInterfaceAddresses).flatMap(Collection::stream).map(InterfaceAddress::getAddress).anyMatch(i -> !i.isLoopbackAddress() && i instanceof Inet6Address);
            if (ipv6Supported) {
                return InetAddress.getByName("::");
            }
            return InetAddress.getByName("0.0.0.0");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

