/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.log;

import io.fusionauth.http.log.Level;
import io.fusionauth.http.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;

public abstract class BaseLogger
implements Logger {
    protected Level level = Level.Info;

    @Override
    public void debug(String message) {
        if (this.getLevelOrdinal() <= Level.Debug.ordinal()) {
            this.handleMessage(this.format(message, new Object[0]));
        }
    }

    @Override
    public void debug(String message, Object ... values) {
        if (this.getLevelOrdinal() <= Level.Debug.ordinal()) {
            this.handleMessage(this.format(message, values));
        }
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.getLevelOrdinal() <= Level.Debug.ordinal()) {
            this.handleMessage(this.format(message, throwable));
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.getLevelOrdinal() <= Level.Error.ordinal()) {
            this.handleMessage(this.format(message, throwable));
        }
    }

    @Override
    public void error(String message) {
        if (this.getLevelOrdinal() <= Level.Error.ordinal()) {
            this.handleMessage(this.format(message, new Object[0]));
        }
    }

    @Override
    public void info(String message) {
        if (this.getLevelOrdinal() <= Level.Info.ordinal()) {
            this.handleMessage(this.format(message, new Object[0]));
        }
    }

    @Override
    public void info(String message, Object ... values) {
        if (this.getLevelOrdinal() <= Level.Info.ordinal()) {
            this.handleMessage(this.format(message, values));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLevelOrdinal() <= Level.Debug.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLevelOrdinal() <= Level.Error.ordinal();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLevelOrdinal() <= Level.Info.ordinal();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLevelOrdinal() <= Level.Trace.ordinal();
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public void trace(String message, Object ... values) {
        if (this.getLevelOrdinal() <= Level.Trace.ordinal()) {
            this.handleMessage(this.format(message, values));
        }
    }

    @Override
    public void trace(String message) {
        if (this.getLevelOrdinal() <= Level.Trace.ordinal()) {
            this.handleMessage(this.format(message, new Object[0]));
        }
    }

    protected String format(String message, Throwable t) {
        if (t == null) {
            return message;
        }
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        t.printStackTrace(pw);
        pw.flush();
        return this.timestamp() + message + "\n" + writer;
    }

    protected String format(String message, Object ... values) {
        for (Object value : values) {
            String replacement = value != null ? value.toString() : "null";
            message = message.replaceFirst("\\{}", Matcher.quoteReplacement(replacement));
        }
        return this.timestamp() + message;
    }

    protected int getLevelOrdinal() {
        return this.level.ordinal();
    }

    protected abstract void handleMessage(String var1);

    protected String timestamp() {
        return System.currentTimeMillis() + " ";
    }
}

