/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class DelegatingOutputStream
extends OutputStream {
    private final HTTPRequest request;
    private final HTTPResponse response;
    private final OutputStream unCompressingOutputStream;
    private boolean compress;
    private OutputStream outputStream;
    private boolean used;

    public DelegatingOutputStream(HTTPRequest request, HTTPResponse response, OutputStream outputStream, boolean compressByDefault) {
        this.request = request;
        this.response = response;
        this.outputStream = outputStream;
        this.compress = compressByDefault;
        this.unCompressingOutputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        if (this.used) {
            throw new IllegalStateException("The HTTPResponse compression configuration cannot be modified once bytes have been written to it.");
        }
        this.compress = compress;
    }

    public boolean willCompress() {
        if (this.compress) {
            for (String encoding : this.request.getAcceptEncodings()) {
                if (encoding.equalsIgnoreCase("gzip")) {
                    return true;
                }
                if (!encoding.equalsIgnoreCase("deflate")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.used) {
            this.init();
        }
        this.outputStream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.used) {
            this.init();
        }
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.used) {
            this.init();
        }
        this.outputStream.write(b);
    }

    private void init() {
        this.used = true;
        if (!this.compress) {
            return;
        }
        for (String encoding : this.request.getAcceptEncodings()) {
            if (encoding.equalsIgnoreCase("gzip")) {
                try {
                    this.outputStream = new GZIPOutputStream(this.unCompressingOutputStream);
                    this.response.setHeader("Content-Encoding", "gzip");
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!encoding.equalsIgnoreCase("deflate")) continue;
            this.outputStream = new DeflaterOutputStream(this.unCompressingOutputStream);
            this.response.setHeader("Content-Encoding", "deflate");
            return;
        }
        this.compress = false;
    }
}

