/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferOutputStream
extends OutputStream {
    private final int initialSize;
    private final int maxCapacity;
    private byte[] buf;
    private int index;

    public ByteBufferOutputStream() {
        this(64, 0x100000);
    }

    public ByteBufferOutputStream(int size, int maxCapacity) {
        this.initialSize = size;
        this.buf = new byte[size];
        this.maxCapacity = maxCapacity;
    }

    @Override
    public void flush() {
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.index);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureSize(this.index + len);
        System.arraycopy(b, 0, this.buf, this.index, len);
        this.index += len;
    }

    @Override
    public void write(int b) {
        this.ensureSize(this.index + 1);
        this.buf[this.index] = (byte)b;
        ++this.index;
    }

    private void ensureSize(int minCapacity) {
        int oldCapacity = this.buf.length;
        int minGrowth = minCapacity - oldCapacity;
        if (minGrowth > 0) {
            if (minCapacity > this.maxCapacity) {
                throw new IllegalArgumentException("Unable to increase the buffer for ByteBufferOutputStream beyond max of [" + this.maxCapacity + "]");
            }
            this.buf = Arrays.copyOf(this.buf, Math.max(minCapacity, this.initialSize));
        }
    }
}

