/*
 * Decompiled with CFR 0.152.
 */
package functionalj.types.elm.processor;

import functionalj.types.Generic;
import functionalj.types.Type;
import functionalj.types.elm.processor.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UElmType {
    private static final Map<Type, String> primitiveTypes = new HashMap<Type, String>();

    public static String emlType(Type type) {
        String basicType = UElmType.elmBasicType(type);
        if (basicType != null) {
            return basicType;
        }
        return UElmType.elmFullName(type);
    }

    public static String elmParamType(Type type) {
        return UElmType.param(type);
    }

    public static String elmParamType(String type) {
        return UElmType.wrap(type);
    }

    private static String elmFullName(Type type) {
        String simpleName = type.simpleName();
        String packageName = type.packageName();
        if (packageName == null) {
            return simpleName;
        }
        String moduleName = Stream.of(packageName.split("\\.")).map(Utils::toTitleCase).collect(Collectors.joining("."));
        if (moduleName.isEmpty()) {
            return simpleName;
        }
        return moduleName + "." + simpleName;
    }

    private static String elmBasicType(Type type) {
        String primitiveElmType = primitiveTypes.get(type);
        if (primitiveElmType != null) {
            return primitiveElmType;
        }
        if (type.isList() || type.isFuncList()) {
            String elmType = UElmType.elmListType(type);
            return elmType;
        }
        if (type.isMap() || type.isFuncMap()) {
            String elmType = UElmType.elmMapType(type);
            return elmType;
        }
        if (type.isOptional() || type.isNullable()) {
            String elmType = UElmType.elmMayBeType(type);
            return elmType;
        }
        return null;
    }

    private static String elmListType(Type type) {
        Type aType = ((Generic)type.generics().get(0)).toType();
        String aStrg = UElmType.param(aType);
        String elmType = "List " + aStrg;
        return elmType;
    }

    private static String elmMapType(Type type) {
        Type kType = ((Generic)type.generics().get(0)).toType();
        String kStrg = UElmType.param(kType);
        Type vType = ((Generic)type.generics().get(1)).toType();
        String vStrg = UElmType.param(vType);
        String elmType = "Dict " + kStrg + " " + vStrg;
        return elmType;
    }

    public static String elmMayBeType(Type type) {
        Type aType = ((Generic)type.generics().get(0)).toType();
        String aStrg = UElmType.param(aType);
        String elmType = "Maybe " + aStrg;
        return elmType;
    }

    public static String elmMayBeOfType(Type type) {
        String aStrg = UElmType.param(type);
        String elmType = "Maybe " + aStrg;
        return elmType;
    }

    private static String param(Type type) {
        String emlType = UElmType.emlType(type);
        String paramType = UElmType.wrap(emlType);
        return paramType;
    }

    private static String wrap(String typeStr) {
        if (typeStr.startsWith("(") && typeStr.endsWith("")) {
            return typeStr;
        }
        if (!typeStr.contains(" ")) {
            return typeStr;
        }
        return "(" + typeStr + ")";
    }

    public static String encoderNameOf(Type type, String name) {
        return UElmType.encoderNameOf(type, name, false);
    }

    public static String encoderNameOf(Type type, String name, boolean isNullable) {
        boolean isOptionalType;
        name = name != null ? name : "";
        boolean bl = isOptionalType = type.isOptional() || type.isNullable();
        if (isNullable || isOptionalType) {
            Type paramType = isOptionalType ? ((Generic)type.generics().get(0)).toType() : type;
            String paramEncoder = UElmType.encoderNameOf(paramType, name);
            return "Maybe.withDefault Json.Encode.null (Maybe.map " + paramEncoder + ")";
        }
        String primitiveElmType = primitiveTypes.get(type);
        if (primitiveElmType != null) {
            return "Json.Encode." + primitiveElmType.toLowerCase() + " " + name;
        }
        String typeName = Utils.toCamelCase(type.simpleName());
        if (type.isList() || type.isFuncList()) {
            Type paramType = ((Generic)type.generics().get(0)).toType();
            String genericPrimitiveType = primitiveTypes.get(paramType);
            if (genericPrimitiveType != null) {
                return "Json.Encode.list Json.Encode." + genericPrimitiveType.toLowerCase() + " " + name;
            }
            return typeName + "ListEncoder " + name;
        }
        if (type.isMap() || type.isFuncMap()) {
            throw new UnsupportedOperationException("Encoder of map type is not yet support.");
        }
        return typeName + "Encoder " + name;
    }

    public static String decoderNameOf(Type type) {
        String primitiveElmType = primitiveTypes.get(type);
        if (primitiveElmType != null) {
            return "Json.Decode." + primitiveElmType.toLowerCase();
        }
        String typeName = Utils.toCamelCase(type.simpleName());
        if (type.isList() || type.isFuncList()) {
            return typeName + "ListDecode";
        }
        if (type.isMap() || type.isFuncMap()) {
            throw new UnsupportedOperationException("Decoder of map type is not yet support.");
        }
        if (type.isOptional() || type.isNullable()) {
            throw new UnsupportedOperationException("Decoder of optional type is not yet support.");
        }
        return typeName + "Decoder";
    }

    static {
        primitiveTypes.put(Type.BOOL, "Bool");
        primitiveTypes.put(Type.BOOLEAN, "Bool");
        primitiveTypes.put(Type.BYT, "Int");
        primitiveTypes.put(Type.BYTE, "Int");
        primitiveTypes.put(Type.SHRT, "Int");
        primitiveTypes.put(Type.SHORT, "Int");
        primitiveTypes.put(Type.INT, "Int");
        primitiveTypes.put(Type.INTEGER, "Int");
        primitiveTypes.put(Type.LNG, "Int");
        primitiveTypes.put(Type.LONG, "Int");
        primitiveTypes.put(Type.BIGINTEGER, "Int");
        primitiveTypes.put(Type.FLT, "Float");
        primitiveTypes.put(Type.FLOAT, "Float");
        primitiveTypes.put(Type.DBL, "Float");
        primitiveTypes.put(Type.DOUBLE, "Float");
        primitiveTypes.put(Type.BIGDECIMAL, "Float");
        primitiveTypes.put(Type.CHR, "Char");
        primitiveTypes.put(Type.CHARACTER, "Char");
        primitiveTypes.put(Type.STR, "String");
        primitiveTypes.put(Type.STRING, "String");
    }
}

