/*
 * Decompiled with CFR 0.152.
 */
package functionalj.types.elm.processor;

import functionalj.types.elm.processor.ElmFunctionBuilder;
import functionalj.types.elm.processor.Utils;
import functionalj.types.struct.generator.ILines;

public interface ElmTypeDef {
    public String typeName();

    default public String camelName() {
        String camelName = Utils.toCamelCase(this.typeName());
        return camelName;
    }

    public String encoderName();

    public String decoderName();

    public ElmFunctionBuilder encoder();

    public ElmFunctionBuilder decoder();

    default public ElmFunctionBuilder listEncoder() {
        String listName = this.camelName() + "List";
        String funcName = listName + "Encoder";
        String declaration = "List " + this.typeName() + " -> Json.Encode.Value";
        String parameters = listName;
        ILines body = ILines.line((String[])new String[]{"Json.Encode.list " + this.encoderName() + " " + listName});
        return new ElmFunctionBuilder(funcName, declaration, parameters, body);
    }

    default public ElmFunctionBuilder listDecoder() {
        String listName = this.camelName() + "List";
        String funcName = listName + "Decoder";
        String declaration = "Json.Decode.Decoder (List " + this.typeName() + ")";
        String parameters = "";
        ILines body = ILines.line((String[])new String[]{"Json.Decode.list " + this.decoderName()});
        return new ElmFunctionBuilder(funcName, declaration, parameters, body);
    }

    default public ElmFunctionBuilder decode() {
        String funcName = "decode" + this.typeName();
        String declaration = "String -> Result Json.Decode.Error " + this.typeName();
        String parameters = "";
        ILines body = ILines.line((String[])new String[]{"Json.Decode.decodeString " + this.decoderName()});
        return new ElmFunctionBuilder(funcName, declaration, parameters, body);
    }

    default public ElmFunctionBuilder decodeList() {
        String funcName = "decode" + this.typeName() + "List";
        String declaration = "String -> Result Json.Decode.Error (List " + this.typeName() + ")";
        String parameters = "";
        ILines body = ILines.line((String[])new String[]{"Json.Decode.decodeString " + this.camelName() + "ListDecoder"});
        return new ElmFunctionBuilder(funcName, declaration, parameters, body);
    }

    default public ElmFunctionBuilder encode() {
        String funcName = "encode" + this.typeName();
        String declaration = this.typeName() + " -> Int -> String";
        String parameters = this.camelName() + " indent";
        ILines body = ILines.line((String[])new String[]{this.encoderName() + " " + this.camelName() + " |> Json.Encode.encode indent"});
        return new ElmFunctionBuilder(funcName, declaration, parameters, body);
    }

    default public ElmFunctionBuilder encodeList() {
        String funcName = "encode" + this.typeName() + "List";
        String declaration = "List " + this.typeName() + " -> Int -> String";
        String parameters = this.camelName() + "List indent";
        ILines body = ILines.line((String[])new String[]{this.camelName() + "ListEncoder " + this.camelName() + "List |> Json.Encode.encode indent"});
        return new ElmFunctionBuilder(funcName, declaration, parameters, body);
    }
}

