/*
 * Decompiled with CFR 0.152.
 */
package functionalj.types.elm.processor;

import functionalj.types.Type;
import functionalj.types.elm.processor.ElmFunctionBuilder;
import functionalj.types.elm.processor.ElmStructSpec;
import functionalj.types.elm.processor.ElmTypeDef;
import functionalj.types.elm.processor.UElmType;
import functionalj.types.elm.processor.Utils;
import functionalj.types.struct.generator.Getter;
import functionalj.types.struct.generator.ILines;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ElmStructBuilder
implements ElmTypeDef {
    private final ElmStructSpec spec;
    private final List<String> choiceTypes;
    private static final String topTemplate = "-- Generated by FunctionJ.io ( https://functionalj.io ) on %6$s \nmodule %3$s exposing\n    ( %1$s\n    , %2$sEncoder\n    , %2$sDecoder\n    , encode%1$s\n    , decode%1$s\n    , %2$sListEncoder\n    , %2$sListDecoder\n    , encode%1$sList\n    , decode%1$sList\n    )\n\nimport Json.Decode\nimport Json.Decode.Pipeline\nimport Json.Encode\n\n%4$s\n\n\n-- elm install elm/json\n-- elm install NoRedInk/elm-json-decode-pipeline\n\n%5$s\n";
    private static final String separator = "\n\n\n";

    public ElmStructBuilder(ElmStructSpec spec, List<String> structTypes, List<String> choiceTypes) {
        this.spec = spec;
        this.choiceTypes = choiceTypes;
    }

    @Override
    public String typeName() {
        return this.spec.typeName();
    }

    @Override
    public String encoderName() {
        return this.camelName() + "Encoder";
    }

    @Override
    public String decoderName() {
        return this.camelName() + "Decoder";
    }

    public ILines typeDefinition() {
        ILines definition = ILines.line((String[])new String[]{"type alias " + this.spec.typeName() + " = "});
        String currentPackageName = this.spec.sourceSpec().getPackageName();
        String currentSimpleName = this.spec.sourceSpec().toType().simpleName();
        Stream fields = this.spec.sourceSpec().getGetters().stream().map(getter -> ElmStructBuilder.toField(currentPackageName, currentSimpleName, getter)).map(ILines.toLine);
        ILines lines = ILines.linesOf(fields).containWith("{", ",", "}");
        return definition.append(ILines.indent((ILines)lines));
    }

    @Override
    public ElmFunctionBuilder encoder() {
        String typeName = this.spec.typeName();
        String name = this.encoderName();
        String declaration = typeName + " -> Json.Encode.Value";
        String params = this.camelName();
        ILines firstLine = ILines.line((String[])new String[]{"Json.Encode.object"});
        ILines fieldEncoders = ILines.linesOf(this.spec.sourceSpec().getGetters().stream().map(ElmStructBuilder.toFieldEncoder(typeName)).map(ILines.toLine)).containWith("[", ",", "]").indent(1);
        ILines body = firstLine.append(fieldEncoders);
        return new ElmFunctionBuilder(name, declaration, params, body);
    }

    private static String toField(String currentPackageName, String currentSimpleName, Getter getter) {
        String fieldName = getter.name();
        String emlType = ElmStructBuilder.emlType(currentPackageName, currentSimpleName, getter.type());
        String maybe = getter.isNullable() ? "Maybe " : "";
        return fieldName + " : " + maybe + emlType;
    }

    private static String emlType(String currentPackageName, String currentSimpleName, Type type) {
        String typePackageName = type.packageName();
        String typeSimpleName = type.simpleName();
        if (currentPackageName.equals(typePackageName) && !currentSimpleName.equals(typeSimpleName)) {
            return typeSimpleName;
        }
        return UElmType.emlType(type);
    }

    private static Function<Getter, String> toFieldEncoder(String typeName) {
        return getter -> ElmStructBuilder.toFieldEncoder(typeName, getter);
    }

    private static String toFieldEncoder(String typeName, Getter getter) {
        String fieldName = getter.name();
        String camelName = Utils.toCamelCase(typeName);
        String typeEncoder = UElmType.encoderNameOf(getter.type(), camelName + "." + fieldName, getter.isNullable());
        return "( \"" + fieldName + "\", " + typeEncoder + " )";
    }

    @Override
    public ElmFunctionBuilder decoder() {
        String typeName = this.spec.typeName();
        String name = this.decoderName();
        String declaration = "Json.Decode.Decoder " + typeName;
        String params = "";
        ILines firstLine = ILines.line((String[])new String[]{"Json.Decode.succeed " + typeName});
        ILines fieldEncoders = ILines.linesOf(this.spec.sourceSpec().getGetters().stream().map(ElmStructBuilder.toFieldDecoder(typeName)).map(ILines.toLine)).indent(1);
        ILines body = firstLine.append(fieldEncoders);
        return new ElmFunctionBuilder(name, declaration, params, body);
    }

    private static Function<Getter, String> toFieldDecoder(String typeName) {
        return getter -> ElmStructBuilder.toFieldDecoder(typeName, getter);
    }

    private static String toFieldDecoder(String typeName, Getter getter) {
        String fieldName = getter.name();
        String rawTypeDecoder = UElmType.decoderNameOf(getter.type());
        String qualifier = getter.isRequired() ? "required" : "optional";
        String typeDecoder = getter.isRequired() ? rawTypeDecoder : "(Json.Decode.maybe " + rawTypeDecoder + ") Nothing";
        return "|> Json.Decode.Pipeline." + qualifier + " \"" + fieldName + "\" " + typeDecoder;
    }

    private String fileTemplate(ILines ... ilines) {
        LocalDateTime genTime = LocalDateTime.now();
        String typeName = this.typeName();
        String camalName = this.camelName();
        String moduleName = this.spec.moduleName();
        String imports = this.imports();
        String content = Stream.of(ilines).map(ILines::toText).collect(Collectors.joining(separator));
        String fileContent = String.format(topTemplate, typeName, camalName, moduleName, imports, content, genTime);
        return fileContent;
    }

    private String imports() {
        String currentPackageName = this.spec.sourceSpec().getPackageName();
        String currentSimpleName = this.spec.sourceSpec().toType().simpleName();
        String getters = this.spec.sourceSpec().getGetters().stream().map(Getter::type).filter(type -> currentPackageName.equals(type.packageName())).filter(type -> !currentSimpleName.equals(type.simpleName())).map(type -> this.localImport((Type)type)).collect(Collectors.joining(",\n    "));
        return getters;
    }

    private String localImport(Type type) {
        String typeSimpleName = type.simpleName();
        boolean isChoice = this.choiceTypes.contains(typeSimpleName);
        String specific = isChoice ? "," + typeSimpleName + "(..)" : "";
        return "import " + typeSimpleName + " exposing (.." + specific + ")";
    }

    public String toElmCode() {
        return this.fileTemplate(this.typeDefinition(), this.encoder(), this.decoder(), this.encode(), this.decode(), this.listEncoder(), this.listDecoder(), this.encodeList(), this.decodeList());
    }
}

