/*
 * Decompiled with CFR 0.152.
 */
package functionalj.types.elm.processor;

import functionalj.types.choice.generator.model.SourceSpec;
import functionalj.types.elm.Elm;
import functionalj.types.elm.processor.Utils;
import functionalj.types.input.InputElement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ElmChoiceSpec {
    private final SourceSpec sourceSpec;
    private final String typeName;
    private final String folderName;
    private final String generatedDirectory;

    public ElmChoiceSpec(SourceSpec sourceSpec, InputElement element) {
        this.sourceSpec = sourceSpec;
        this.typeName = sourceSpec.targetName;
        List<String> baseModule = Arrays.asList(this.elmBaseModule(element, sourceSpec).split("\\."));
        this.folderName = baseModule.stream().map(Utils::toTitleCase).collect(Collectors.joining("/"));
        String generatedDirectory = ((Elm)element.annotation(Elm.class)).generatedDirectory();
        this.generatedDirectory = generatedDirectory == null ? "./generated/elm/" : generatedDirectory;
    }

    ElmChoiceSpec(SourceSpec sourceSpec, String typeName, String folderName) {
        this(sourceSpec, typeName, folderName, null);
    }

    ElmChoiceSpec(SourceSpec sourceSpec, String typeName, String folderName, String generatedDirectory) {
        this.sourceSpec = sourceSpec;
        this.typeName = typeName;
        this.folderName = folderName;
        this.generatedDirectory = generatedDirectory == null ? "./generated/elm/" : generatedDirectory;
    }

    private String elmBaseModule(InputElement element, SourceSpec sourceSpec) {
        String baseModule = ((Elm)element.annotation(Elm.class)).baseModule();
        String elmtPackage = sourceSpec.sourceType.packageName();
        return "FROM_PACAKGE_NAME".equals(baseModule) ? elmtPackage : baseModule;
    }

    public SourceSpec sourceSpec() {
        return this.sourceSpec;
    }

    public String typeName() {
        return this.typeName;
    }

    public String fileName() {
        return this.typeName + ".elm";
    }

    public String moduleName() {
        String moduleBase = this.folderName == null || this.folderName.isEmpty() ? "" : this.folderName.replace('/', '.') + ".";
        return moduleBase + this.typeName;
    }

    public String folderName() {
        return this.folderName;
    }

    public String generatedDirectory() {
        return this.generatedDirectory;
    }

    public String toString() {
        return "ElmStructSpec [typeName=" + this.typeName + ", fileName=" + this.fileName() + ", moduleName=" + this.moduleName() + ", folderName=" + this.folderName + ", generatedDirectory=" + this.generatedDirectory + "]";
    }
}

