/*
 * Decompiled with CFR 0.152.
 */
package functionalj.types.elm.processor;

import functionalj.types.Generic;
import functionalj.types.Type;
import functionalj.types.choice.generator.model.Case;
import functionalj.types.choice.generator.model.CaseParam;
import functionalj.types.elm.processor.ElmChoiceSpec;
import functionalj.types.elm.processor.ElmFunctionBuilder;
import functionalj.types.elm.processor.ElmTypeDef;
import functionalj.types.elm.processor.UElmType;
import functionalj.types.struct.generator.ILines;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ElmChoiceBuilder
implements ElmTypeDef {
    private final ElmChoiceSpec spec;
    private final List<String> choiceTypes;
    private static Function<CaseParam, String> toParamType = ElmChoiceBuilder::toParamType;
    private static Function<Case, String> toCaseTypes = ElmChoiceBuilder::toCaseTypes;
    private static Function<Case, ILines> toCaseField = ElmChoiceBuilder::toCaseField;
    private static Function<CaseParam, String> toCaseParam = ElmChoiceBuilder::toCaseParam;
    private static Function<CaseParam, ILines> toChoiceParamDecoder = ElmChoiceBuilder::toChoiceParamDecoder;
    private static final String topTemplate = "-- Generated by FunctionJ.io ( https://functionalj.io ) on %6$s \nmodule %3$s exposing\n    ( %1$s(..)\n    , %2$sEncoder\n    , %2$sDecoder\n    , encode%1$s\n    , decode%1$s\n    , %2$sListEncoder\n    , %2$sListDecoder\n    , encode%1$sList\n    , decode%1$sList\n    )\n\nimport Json.Decode\nimport Json.Decode.Pipeline\nimport Json.Encode\n\n%4$s\n\n\n-- elm install elm/json\n-- elm install NoRedInk/elm-json-decode-pipeline\n\n%5$s\n";
    private static final String separator = "\n\n\n";

    public ElmChoiceBuilder(ElmChoiceSpec spec, List<String> structTypes, List<String> choiceTypes) {
        this.spec = spec;
        this.choiceTypes = choiceTypes;
    }

    @Override
    public String typeName() {
        return this.spec.typeName();
    }

    @Override
    public String encoderName() {
        return this.camelName() + "Encoder";
    }

    @Override
    public String decoderName() {
        return this.camelName() + "Decoder";
    }

    public ILines typeDefinition() {
        ILines definition = ILines.line((String[])new String[]{"type " + this.spec.typeName()});
        Stream choices = this.spec.sourceSpec().choices.stream().map(toCaseTypes).map(ILines.toLine);
        ILines lines = ILines.linesOf(choices).containWith("=", "|", null);
        return definition.append(ILines.indent((ILines)lines));
    }

    private static String toParamType(CaseParam caseParam) {
        Type paramType = caseParam.type();
        String elmParamType = caseParam.isNullable() ? UElmType.elmParamType(UElmType.elmMayBeOfType(paramType)) : UElmType.elmParamType(paramType);
        return elmParamType;
    }

    private static String toCaseTypes(Case choice) {
        String name = choice.name;
        String params = choice.params.stream().map(toParamType).collect(Collectors.joining(" "));
        return name + " " + params;
    }

    @Override
    public ElmFunctionBuilder encoder() {
        String typeName = this.spec.typeName();
        String name = this.encoderName();
        String camelName = this.camelName();
        String declaration = typeName + " -> Json.Encode.Value";
        ILines caseExpr = ILines.line((String[])new String[]{"case " + camelName + " of"});
        ILines choices = ILines.linesOf(this.spec.sourceSpec().choices.stream().map(toCaseField));
        ILines body = caseExpr.append(choices.indent(1));
        return new ElmFunctionBuilder(name, declaration, camelName, body);
    }

    private static ILines toCaseField(Case choice) {
        String paramNameList = choice.params.stream().map(param -> param.name()).collect(Collectors.joining(" "));
        ILines matchCase = ILines.line((String[])new String[]{choice.name + " " + paramNameList + " ->"});
        ILines targetFunc = ILines.line((String[])new String[]{"Json.Encode.object"});
        Stream taggedEncoder = ILines.line((String[])new String[]{"( \"__tagged\", Json.Encode.string \"" + choice.name + "\" )"}).toStream();
        Stream encoders = choice.params.stream().map(toCaseParam).map(ILines.toLine);
        ILines params = ILines.linesOf(Stream.concat(taggedEncoder, encoders)).containWith("[", ",", "]").indent(1);
        return matchCase.append(targetFunc.append(params).indent(1));
    }

    private static String toCaseParam(CaseParam caseParam) {
        String encoder = UElmType.encoderNameOf(caseParam.type(), caseParam.name(), caseParam.isNullable());
        String name = caseParam.name();
        return "( \"" + name + "\", " + encoder + " )";
    }

    @Override
    public ElmFunctionBuilder decoder() {
        String typeName = this.spec.typeName();
        String name = this.decoderName();
        String declaration = "Json.Decode.Decoder " + typeName;
        String params = "";
        ILines firstLines = ILines.line((String[])new String[]{"Json.Decode.field \"__tagged\" Json.Decode.string", "    |> Json.Decode.andThen", "        (\\str ->", "            case str of"});
        ILines fieldEncoders = ILines.linesOf(this.spec.sourceSpec().choices.stream().map(ElmChoiceBuilder.toFieldDecoder(typeName))).indent(4);
        ILines lastLines = ILines.line((String[])new String[]{"                somethingElse ->", "                    Json.Decode.fail <| \"Unknown tagged: \" ++ somethingElse", ")"});
        ILines body = firstLines.append(fieldEncoders).append(lastLines);
        return new ElmFunctionBuilder(name, declaration, params, body);
    }

    private static Function<Case, ILines> toFieldDecoder(String typeName) {
        return choice -> ElmChoiceBuilder.toFieldDecoder(typeName, choice);
    }

    private static ILines toFieldDecoder(String typeName, Case choice) {
        String fieldName = choice.name;
        ILines firstLine = ILines.line((String[])new String[]{"\"" + fieldName + "\" ->"});
        ILines secondLine = ILines.line((String[])new String[]{"    Json.Decode.succeed " + fieldName});
        ILines restOfLines = ILines.linesOf(choice.params.stream().map(toChoiceParamDecoder)).indent(2);
        return firstLine.append(secondLine).append(restOfLines).append(ILines.line((String[])new String[]{""}));
    }

    private static ILines toChoiceParamDecoder(CaseParam caseParam) {
        Type caseType = caseParam.type();
        boolean isList = caseType.isList() || caseType.isFuncList();
        Type bareType = caseType.isNullable() || caseType.isOptional() || isList ? ((Generic)caseType.generics().get(0)).toType() : caseType;
        boolean isNullable = caseParam.isNullable() || caseType.isNullable() || caseType.isOptional();
        String reqOrOpt = isNullable ? "Json.Decode.Pipeline.optional" : "Json.Decode.Pipeline.required";
        String quotedName = "\"" + caseParam.name() + "\"";
        String decoderType = isList ? "(Json.Decode.list " + UElmType.decoderNameOf(bareType) + ")" : (isNullable ? "(Json.Decode.maybe " + UElmType.decoderNameOf(bareType) + ") Nothing" : UElmType.decoderNameOf(caseType));
        return ILines.line((String[])new String[]{"|> " + reqOrOpt + " " + quotedName + " " + decoderType});
    }

    private String fileTemplate(ILines ... ilines) {
        LocalDateTime genTime = LocalDateTime.now();
        String typeName = this.typeName();
        String camalName = this.camelName();
        String moduleName = this.spec.moduleName();
        String imports = this.imports();
        String content = Stream.of(ilines).map(ILines::toText).collect(Collectors.joining(separator));
        String fileContent = String.format(topTemplate, typeName, camalName, moduleName, imports, content, genTime);
        return fileContent;
    }

    private String imports() {
        String currentPackageName = this.spec.sourceSpec().sourceType.packageName();
        String currentSimpleName = this.spec.sourceSpec().sourceType.simpleName();
        String getters = this.spec.sourceSpec().choices.stream().flatMap(choice -> choice.params.stream()).map(param -> param.type()).filter(type -> currentPackageName.equals(type.packageName())).filter(type -> !currentSimpleName.equals(type.simpleName())).map(type -> this.localImport((Type)type)).collect(Collectors.joining(",\n    "));
        return getters;
    }

    private String localImport(Type type) {
        String typeSimpleName = type.simpleName();
        boolean isChoice = this.choiceTypes.contains(typeSimpleName);
        String specific = isChoice ? "," + typeSimpleName + "(..)" : "";
        return "import " + typeSimpleName + " exposing (.." + specific + ")";
    }

    public String toElmCode() {
        return this.fileTemplate(this.typeDefinition(), this.encoder(), this.decoder(), this.encode(), this.decode(), this.listEncoder(), this.listDecoder(), this.encodeList(), this.decodeList());
    }
}

