/*
 * Decompiled with CFR 0.152.
 */
package functionalj.types.elm.processor;

import functionalj.types.Choice;
import functionalj.types.Struct;
import functionalj.types.choice.ChoiceSpec;
import functionalj.types.elm.Elm;
import functionalj.types.elm.processor.ElmChoiceBuilder;
import functionalj.types.elm.processor.ElmChoiceSpec;
import functionalj.types.elm.processor.ElmStructBuilder;
import functionalj.types.elm.processor.ElmStructSpec;
import functionalj.types.input.Environment;
import functionalj.types.input.InputElement;
import functionalj.types.struct.SourceSpecBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ElmAnnotationProcessor
extends AbstractProcessor {
    private Environment environment = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        Elements elementUtils = processingEnv.getElementUtils();
        Types typeUtils = processingEnv.getTypeUtils();
        Messager messager = processingEnv.getMessager();
        Filer filer = processingEnv.getFiler();
        this.environment = new Environment(elementUtils, typeUtils, messager, filer);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Elm.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean hasError = false;
        List<String> structTypes = this.collectAllStructTypes(roundEnv);
        List<String> choiceTypes = this.collectAllChoiceTypes(roundEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(Elm.class)) {
            InputElement element2 = this.environment.element(element);
            Struct struct = (Struct)element2.annotation(Struct.class);
            if (struct != null) {
                hasError |= !this.handleStructType(element2, structTypes, choiceTypes);
                continue;
            }
            Choice choice = (Choice)element2.annotation(Choice.class);
            if (choice != null) {
                hasError |= !this.handleChoiceType(element2, structTypes, choiceTypes);
                continue;
            }
            element2.error("The element must either be a struct or a choice.");
        }
        return hasError;
    }

    private List<String> collectAllStructTypes(RoundEnvironment roundEnv) {
        ArrayList<String> allTypes = new ArrayList<String>();
        for (Element element : roundEnv.getElementsAnnotatedWith(Elm.class)) {
            InputElement element2 = this.environment.element(element);
            Struct struct = (Struct)element2.annotation(Struct.class);
            if (struct == null) continue;
            String name = element2.simpleName();
            allTypes.add(name);
        }
        return allTypes;
    }

    private List<String> collectAllChoiceTypes(RoundEnvironment roundEnv) {
        ArrayList<String> allTypes = new ArrayList<String>();
        for (Element element : roundEnv.getElementsAnnotatedWith(Elm.class)) {
            InputElement element2 = this.environment.element(element);
            Choice choice = (Choice)element2.annotation(Choice.class);
            if (choice == null) continue;
            String name = element2.simpleName();
            allTypes.add(name);
        }
        return allTypes;
    }

    private boolean handleStructType(InputElement element, List<String> structTypes, List<String> choiceTypes) {
        SourceSpecBuilder structSpec = new SourceSpecBuilder(element);
        String packageName = structSpec.packageName();
        String specTargetName = structSpec.targetName();
        try {
            ElmStructSpec elmStructSpec = new ElmStructSpec(structSpec.sourceSpec(), element);
            ElmStructBuilder elmStruct = new ElmStructBuilder(elmStructSpec, structTypes, choiceTypes);
            String baseDir = elmStructSpec.generatedDirectory();
            String folderName = elmStructSpec.folderName();
            String fileName = elmStructSpec.fileName();
            String generatedPath = baseDir + folderName + "/";
            String generatedCode = elmStruct.toElmCode();
            String generatedName = generatedPath + fileName;
            this.generateElmCode(generatedPath, generatedCode, generatedName);
            return true;
        }
        catch (Throwable e) {
            element.error("Problem generating the class: " + packageName + "." + specTargetName + ": " + e.getMessage() + ":" + e.getClass() + Arrays.stream(e.getStackTrace()).map(st -> "\n    @" + st).collect(Collectors.joining()));
            return !element.hasError();
        }
    }

    private void generateElmCode(String generatedPath, String generatedCode, String generatedName) throws IOException {
        new File(generatedPath).mkdirs();
        File generatedFile = new File(generatedName);
        List<String> lines = Arrays.asList(generatedCode.split("\n"));
        Files.write(generatedFile.toPath(), lines, new OpenOption[0]);
    }

    private boolean handleChoiceType(InputElement element, List<String> structTypes, List<String> choiceTypes) {
        ChoiceSpec choiceSpec = new ChoiceSpec(element);
        String packageName = choiceSpec.packageName();
        String specTargetName = choiceSpec.targetName();
        try {
            ElmChoiceSpec elmChoiceSpec = new ElmChoiceSpec(choiceSpec.sourceSpec(), element);
            ElmChoiceBuilder elmChoice = new ElmChoiceBuilder(elmChoiceSpec, structTypes, choiceTypes);
            String baseDir = elmChoiceSpec.generatedDirectory();
            String folderName = elmChoiceSpec.folderName();
            String fileName = elmChoiceSpec.fileName();
            String generatedPath = baseDir + folderName + "/";
            String generatedCode = elmChoice.toElmCode();
            String generatedName = generatedPath + fileName;
            this.generateElmCode(generatedPath, generatedCode, generatedName);
            return true;
        }
        catch (Exception exception) {
            String template = "Problem generating the class: %s.%s: %s:%s%s";
            String excMsg = exception.getMessage();
            Class<?> excClass = exception.getClass();
            String stacktrace = Arrays.stream(exception.getStackTrace()).map(st -> "\n    @" + st).collect(Collectors.joining());
            String errMsg = String.format(template, packageName, specTargetName, excMsg, excClass, stacktrace);
            exception.printStackTrace(System.err);
            element.error(errMsg);
            return !element.hasError();
        }
    }
}

