/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.daggeradapter.DaggerMethodScanner;
import com.google.inject.daggeradapter.SupportedAnnotations;
import com.google.inject.internal.ProviderMethodsModule;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public final class DaggerAdapter {
    public static Module from(Object ... daggerModuleObjects) {
        return DaggerAdapter.builder().addModules((Iterable<Object>)ImmutableList.copyOf((Object[])daggerModuleObjects)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Class<?> moduleClass(Object module) {
        return module instanceof Class ? (Class<?>)module : module.getClass();
    }

    private DaggerAdapter() {
    }

    private static class ModuleTraversingQueue {
        private final Deque<Class<?>> queue = new ArrayDeque();
        private final Set<Object> visited = new HashSet<Object>();
        private final ImmutableList.Builder<Object> transitiveModules = ImmutableList.builder();

        private ModuleTraversingQueue() {
        }

        void add(Object module) {
            if (this.visited.add(module)) {
                this.transitiveModules.add(module);
                this.queue.add(DaggerAdapter.moduleClass(module));
            }
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        Class<?> pop() {
            return this.queue.pop();
        }

        ImmutableList<Object> transitiveModules() {
            return this.transitiveModules.build();
        }
    }

    private static final class DaggerCompatibilityModule
    implements Module {
        private final ImmutableList<Object> declaredModules;
        private final Predicate<Method> predicate;

        private DaggerCompatibilityModule(Builder builder) {
            this.declaredModules = builder.modules.build();
            this.predicate = builder.predicate;
        }

        public void configure(Binder binder) {
            binder = binder.skipSources(new Class[]{this.getClass()});
            DaggerMethodScanner scanner = DaggerMethodScanner.create(this.predicate);
            for (Object module : DaggerCompatibilityModule.deduplicateModules(binder, this.transitiveModules())) {
                this.checkIsDaggerModule(module, binder);
                this.validateNoSubcomponents(binder, module);
                DaggerCompatibilityModule.checkUnsupportedDaggerAnnotations(module, binder);
                binder.install(ProviderMethodsModule.forModule(module, (ModuleAnnotatedMethodScanner)scanner));
            }
        }

        private void checkIsDaggerModule(Object module, Binder binder) {
            Class<?> moduleClass;
            Class<?> clazz = moduleClass = module instanceof Class ? (Class<?>)module : module.getClass();
            if (!moduleClass.isAnnotationPresent(dagger.Module.class)) {
                binder.skipSources(new Class[]{this.getClass()}).addError("%s must be annotated with @dagger.Module", new Object[]{moduleClass.getCanonicalName()});
            }
        }

        private static void checkUnsupportedDaggerAnnotations(Object module, Binder binder) {
            for (Method method : DaggerCompatibilityModule.allDeclaredMethods(DaggerAdapter.moduleClass(module))) {
                for (Annotation annotation : method.getAnnotations()) {
                    Class<? extends Annotation> annotationClass = annotation.annotationType();
                    if (!annotationClass.getName().startsWith("dagger.") || SupportedAnnotations.isAnnotationSupported(annotationClass)) continue;
                    binder.addError("%s is annotated with @%s which is not supported by DaggerAdapter", new Object[]{method, annotationClass.getCanonicalName()});
                }
            }
        }

        private static ImmutableList<Method> allDeclaredMethods(Class<?> clazz) {
            ImmutableList.Builder methods = ImmutableList.builder();
            for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
                methods.add((Object[])current.getDeclaredMethods());
            }
            return methods.build();
        }

        private void validateNoSubcomponents(Binder binder, Object module) {
            Class<?> moduleClass = module instanceof Class ? (Class<?>)module : module.getClass();
            dagger.Module moduleAnnotation = moduleClass.getAnnotation(dagger.Module.class);
            if (moduleAnnotation.subcomponents().length > 0) {
                binder.addError("Subcomponents cannot be configured for modules used with DaggerAdapter. %s specifies: %s", new Object[]{moduleClass, Arrays.toString(moduleAnnotation.subcomponents())});
            }
        }

        private ImmutableList<Object> transitiveModules() {
            ModuleTraversingQueue queue = new ModuleTraversingQueue();
            this.declaredModules.forEach(queue::add);
            while (!queue.isEmpty()) {
                dagger.Module module = queue.pop().getAnnotation(dagger.Module.class);
                if (module == null) continue;
                Arrays.asList(module.includes()).forEach(queue::add);
            }
            return queue.transitiveModules();
        }

        private static ImmutableList<Object> deduplicateModules(Binder binder, ImmutableList<Object> transitiveModules) {
            ImmutableList.Builder deduplicatedModules = ImmutableList.builder();
            Multimaps.index(transitiveModules, x$0 -> DaggerAdapter.moduleClass(x$0)).asMap().forEach((moduleClass, duplicates) -> {
                ImmutableSet instances = (ImmutableSet)duplicates.stream().filter(module -> !(module instanceof Class)).collect(ImmutableSet.toImmutableSet());
                if (instances.size() > 1) {
                    binder.addError("Duplicate module instances provided for %s: %s", new Object[]{moduleClass, instances});
                }
                deduplicatedModules.add(Iterables.getFirst((Iterable)instances, duplicates.iterator().next()));
            });
            return deduplicatedModules.build();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("modules", this.declaredModules).toString();
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Object> modules = ImmutableList.builder();
        private Predicate<Method> predicate = Predicates.alwaysTrue();

        public Module build() {
            return new DaggerCompatibilityModule(this);
        }

        public Builder addModules(Iterable<Object> daggerModuleObjects) {
            this.modules.addAll(daggerModuleObjects);
            return this;
        }

        public Builder filter(Predicate<Method> predicate) {
            this.predicate = (Predicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
            return this;
        }
    }
}

