/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.daggeradapter.BindingSubject;
import com.google.inject.daggeradapter.DaggerAdapter;
import dagger.BindsOptionalOf;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Optional;
import javax.inject.Qualifier;
import junit.framework.TestCase;

public class OptionalBindingsTest
extends TestCase {
    public void testBinds() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{BasicModule.class})});
        Binding optionalBinding = injector.getBinding((Key)new Key<Optional<String>>(){});
        BindingSubject.assertThat(optionalBinding).hasProvidedValueThat().isEqualTo(Optional.empty());
        BindingSubject.assertThat(optionalBinding).hasSource(BasicModule.class, "optionalString", new Class[0]);
        Binding qualifiedOptionalBinding = injector.getBinding(Key.get((TypeLiteral)new TypeLiteral<Optional<Integer>>(){}, TestQualifier.class));
        BindingSubject.assertThat(qualifiedOptionalBinding).hasProvidedValueThat().isEqualTo(Optional.empty());
        BindingSubject.assertThat(qualifiedOptionalBinding).hasSource(BasicModule.class, "optionalQualifiedInteger", new Class[0]);
    }

    @dagger.Module
    static interface BasicModule {
        @BindsOptionalOf
        public String optionalString();

        @BindsOptionalOf
        @TestQualifier
        public Integer optionalQualifiedInteger();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface TestQualifier {
    }
}

