/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.daggeradapter.BindingSubject;
import com.google.inject.daggeradapter.DaggerAdapter;
import dagger.multibindings.Multibinds;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import junit.framework.TestCase;

public class MultibindsTest
extends TestCase {
    public void testBinds() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{BasicModule.class})});
        Binding setBinding = injector.getBinding((Key)new Key<Set<Number>>(){});
        BindingSubject.assertThat(setBinding).hasProvidedValueThat().isEqualTo((Object)ImmutableSet.of());
        BindingSubject.assertThat(setBinding).hasSource(BasicModule.class, "set", new Class[0]);
        Binding mapBinding = injector.getBinding((Key)new Key<Map<Integer, Double>>(){});
        BindingSubject.assertThat(mapBinding).hasProvidedValueThat().isEqualTo((Object)ImmutableMap.of());
        BindingSubject.assertThat(mapBinding).hasSource(BasicModule.class, "map", new Class[0]);
        Binding qualifiedSetBinding = injector.getBinding(Key.get((TypeLiteral)new TypeLiteral<Set<Number>>(){}, TestQualifier.class));
        BindingSubject.assertThat(qualifiedSetBinding).hasProvidedValueThat().isEqualTo((Object)ImmutableSet.of());
        BindingSubject.assertThat(qualifiedSetBinding).hasSource(BasicModule.class, "qualifiedSet", new Class[0]);
        Binding qualifiedMapBinding = injector.getBinding(Key.get((TypeLiteral)new TypeLiteral<Map<Integer, Double>>(){}, TestQualifier.class));
        BindingSubject.assertThat(qualifiedMapBinding).hasProvidedValueThat().isEqualTo((Object)ImmutableMap.of());
        BindingSubject.assertThat(qualifiedMapBinding).hasSource(BasicModule.class, "qualifiedMap", new Class[0]);
    }

    @dagger.Module
    static interface BasicModule {
        @Multibinds
        public Set<Number> set();

        @Multibinds
        public Map<Integer, Double> map();

        @Multibinds
        @TestQualifier
        public Set<Number> qualifiedSet();

        @Multibinds
        @TestQualifier
        public Map<Integer, Double> qualifiedMap();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface TestQualifier {
    }
}

