/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.truth.Truth;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.daggeradapter.DaggerAdapter;
import dagger.Provides;
import junit.framework.TestCase;

public class ModuleIncludesTest
extends TestCase {
    public void testIncludedModules() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{Declared.class, Included.class})});
        Truth.assertThat((String)((String)injector.getInstance(String.class))).isEqualTo((Object)"included");
    }

    public void testDeduplicated() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{Includes1.class, Includes2.class})});
        Truth.assertThat((String)((String)injector.getInstance(String.class))).isEqualTo((Object)"deduplicated");
    }

    public void testInstanceOfModuleAndClassLiteral() {
        Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{Deduplicated.class, new Deduplicated()})});
    }

    public void testDeduplicatedModulesFromSeparateDaggerAdapters() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{Includes1.class}), DaggerAdapter.from((Object[])new Object[]{Includes1.class}), DaggerAdapter.from((Object[])new Object[]{Includes2.class}), DaggerAdapter.from((Object[])new Object[]{Includes2.class})});
        Truth.assertThat((String)((String)injector.getInstance(String.class))).isEqualTo((Object)"deduplicated");
    }

    public void testConflictingModuleInstances() {
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new ModuleWithIdentity(), new ModuleWithIdentity()})});
            ModuleIncludesTest.fail();
        }
        catch (CreationException e) {
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Duplicate module instances provided for ModuleIncludesTest$ModuleWithIdentity:");
        }
    }

    public void testInstanceOfModuleAndClassLiteral_InstanceWins() {
        Injector instanceModuleFirst = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new ModuleWithInstanceProvidesMethod(), ModuleWithInstanceProvidesMethod.class})});
        Truth.assertThat((Integer)((Integer)instanceModuleFirst.getInstance(Integer.class))).isEqualTo((Object)0);
        Truth.assertThat((Integer)((Integer)instanceModuleFirst.getInstance(Integer.class))).isEqualTo((Object)1);
        Injector classLiteralFirst = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{ModuleWithInstanceProvidesMethod.class, new ModuleWithInstanceProvidesMethod()})});
        Truth.assertThat((Integer)((Integer)classLiteralFirst.getInstance(Integer.class))).isEqualTo((Object)0);
        Truth.assertThat((Integer)((Integer)classLiteralFirst.getInstance(Integer.class))).isEqualTo((Object)1);
    }

    @dagger.Module
    static final class ModuleWithInstanceProvidesMethod {
        private int i;

        ModuleWithInstanceProvidesMethod() {
        }

        @Provides
        int i() {
            return this.i++;
        }
    }

    @dagger.Module
    static final class ModuleWithIdentity {
        ModuleWithIdentity() {
        }
    }

    @dagger.Module(includes={Deduplicated.class})
    static class Includes2 {
        Includes2() {
        }
    }

    @dagger.Module(includes={Deduplicated.class})
    static class Includes1 {
        Includes1() {
        }
    }

    @dagger.Module
    static class Deduplicated {
        Deduplicated() {
        }

        @Provides
        static String string() {
            return "deduplicated";
        }
    }

    @dagger.Module
    static class Included {
        Included() {
        }

        @Provides
        static String string(Object object) {
            return "included";
        }
    }

    @dagger.Module(includes={Included.class})
    static class Declared {
        Declared() {
        }

        @Provides
        static Object object() {
            return new Object();
        }
    }
}

