/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.truth.Truth;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.daggeradapter.DaggerAdapter;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.util.Providers;
import dagger.Binds;
import dagger.MapKey;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import dagger.multibindings.StringKey;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import javax.inject.Qualifier;
import junit.framework.TestCase;
import org.junit.Assert;

public class IntoMapTest
extends TestCase {
    public void testMapBindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new MapBindingDaggerModule1(), new MapBindingDaggerModule2()})});
        Truth.assertThat((Map)((Map)injector.getInstance((Key)new Key<Map<String, Integer>>(){}))).containsExactly((Object)"five", (Object)5, new Object[]{"ten", 10, "twenty", 20});
    }

    public void testMapBindingsWithAnnotation() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new MapBindingWithAnnotationDaggerModule()})});
        Truth.assertThat((Map)((Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, Integer>>(){}, AnnotationOnMap.class)))).containsExactly((Object)"qualified", (Object)4, new Object[0]);
    }

    public void testMapBindingsWithGuiceModule() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new MultibindingGuiceModule(), DaggerAdapter.from((Object[])new Object[]{new MapBindingDaggerModule1(), new MapBindingDaggerModule2()})});
        Truth.assertThat((Map)((Map)injector.getInstance((Key)new Key<Map<String, Integer>>(){}))).containsExactly((Object)"five", (Object)5, new Object[]{"ten", 10, "twenty", 20, "guice-zero", 0, "guice-provider-2", 2});
    }

    public void testWrappedMapKeys() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new WrappedMapKeyModule()})});
        Map map = (Map)injector.getInstance((Key)new Key<Map<Wrapped, Integer>>(){});
        Truth.assertThat((Map)map).hasSize(3);
        map.forEach((key, value) -> {
            if (value == 0) {
                IntoMapTest.assertWrappedEquals(0, 0L, "", key);
            } else if (value == 1) {
                IntoMapTest.assertWrappedEquals(1, 1L, "1", key);
            } else if (value == 2) {
                IntoMapTest.assertWrappedEquals(2, 2L, "2", key);
            } else {
                throw new AssertionError();
            }
        });
    }

    private static void assertWrappedEquals(int i, long l, String defaultValue, Wrapped actual) {
        Truth.assertThat((Integer)actual.i()).isEqualTo((Object)i);
        Truth.assertThat((Long)actual.l()).isEqualTo((Object)l);
        Truth.assertThat((String)actual.defaultValue()).isEqualTo((Object)defaultValue);
    }

    public void testBinds() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{BindsModule.class})});
        Map map = (Map)injector.getInstance((Key)new Key<Map<String, Object>>(){});
        Truth.assertThat((Map)map).containsExactly((Object)"hello", (Object)"world", new Object[0]);
    }

    public void testMissingRuntimeRetention() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new MissingRuntimeRetentionModule()})}));
        Truth.assertThat((Iterable)exception.getErrorMessages()).hasSize(1);
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Missing @MapKey annotation on method");
    }

    public void testMissingRuntimeRetentionUsingBinds() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{MissingRuntimeRetentionBindsModule.class})}));
        exception.printStackTrace();
        Truth.assertThat((Iterable)exception.getErrorMessages()).hasSize(1);
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Missing @MapKey annotation on method");
    }

    @dagger.Module
    static abstract class MissingRuntimeRetentionBindsModule {
        MissingRuntimeRetentionBindsModule() {
        }

        @Binds
        @IntoMap
        @CustomMapKey(value="hello")
        abstract Object binds(String var1);

        @Provides
        static String provideValue() {
            return "world";
        }
    }

    @dagger.Module
    static class MissingRuntimeRetentionModule {
        MissingRuntimeRetentionModule() {
        }

        @Provides
        @IntoMap
        @CustomMapKey(value="hello")
        String binds() {
            return "world";
        }
    }

    @MapKey
    static @interface CustomMapKey {
        public String value() default "";
    }

    @dagger.Module
    static interface BindsModule {
        @Binds
        @IntoMap
        @StringKey(value="hello")
        public Object binds(String var1);

        @Provides
        public static String world() {
            return "world";
        }
    }

    @dagger.Module
    static class HasConflict {
        HasConflict() {
        }

        @Provides
        @IntoMap
        @Wrapped(i=1, l=1L, defaultValue="1")
        int ones() {
            return 1;
        }
    }

    @dagger.Module
    static class WrappedMapKeyModule {
        WrappedMapKeyModule() {
        }

        @Provides
        @IntoMap
        @Wrapped(i=0, l=0L)
        int defaultValue() {
            return 0;
        }

        @Provides
        @IntoMap
        @Wrapped(i=1, l=1L, defaultValue="1")
        int ones() {
            return 1;
        }

        @Provides
        @IntoMap
        @Wrapped(i=2, l=2L, defaultValue="2")
        int twos() {
            return 2;
        }
    }

    @MapKey(unwrapValue=false)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Wrapped {
        public int i();

        public long l();

        public String defaultValue() default "";
    }

    static class MultibindingGuiceModule
    implements Module {
        MultibindingGuiceModule() {
        }

        public void configure(Binder binder) {
            MapBinder mb = MapBinder.newMapBinder((Binder)binder, String.class, Integer.class);
            mb.addBinding((Object)"guice-zero").toInstance((Object)0);
            mb.addBinding((Object)"guice-provider-2").toProvider(Providers.of((Object)2));
        }
    }

    @dagger.Module
    static class MapBindingWithAnnotationDaggerModule {
        MapBindingWithAnnotationDaggerModule() {
        }

        @Provides
        @IntoMap
        @StringKey(value="qualified")
        @AnnotationOnMap
        Integer anInteger() {
            return 4;
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AnnotationOnMap {
    }

    @dagger.Module
    static class MapBindingDaggerModule2 {
        MapBindingDaggerModule2() {
        }

        @Provides
        @IntoMap
        @StringKey(value="twenty")
        Integer anInteger() {
            return 20;
        }
    }

    @dagger.Module
    static class MapBindingDaggerModule1 {
        MapBindingDaggerModule1() {
        }

        @Provides
        @IntoMap
        @StringKey(value="five")
        Integer boxedPrimitive() {
            return 5;
        }

        @Provides
        @IntoMap
        @StringKey(value="ten")
        int primitive() {
            return 10;
        }
    }
}

