/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.daggeradapter.DaggerAdapter;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Providers;
import dagger.Binds;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoSet;
import dagger.producers.ProducerModule;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Qualifier;
import junit.framework.TestCase;

public class DaggerAdapterTest
extends TestCase {
    public void testSimpleModule() {
        Injector i = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new SimpleDaggerModule()})});
        Truth.assertThat((Integer)((Integer)i.getInstance(Integer.class))).isEqualTo((Object)1);
    }

    public void testInteractionWithGuiceModules() {
        Injector i = Guice.createInjector((Module[])new Module[]{new SimpleGuiceModule(), DaggerAdapter.from((Object[])new Object[]{new SimpleDaggerModule()})});
        Truth.assertThat((String)((String)i.getInstance(String.class))).isEqualTo((Object)"1");
    }

    public void testSetBindings() {
        Injector i = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new SetBindingDaggerModule1(), new SetBindingDaggerModule2()})});
        Truth.assertThat((Iterable)((Iterable)i.getInstance((Key)new Key<Set<Integer>>(){}))).isEqualTo((Object)ImmutableSet.of((Object)3, (Object)5));
    }

    public void testSetBindingsWithAnnotation() {
        Injector i = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new SetBindingWithAnnotationDaggerModule()})});
        Truth.assertThat((Iterable)((Iterable)i.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Integer>>(){}, AnnotationOnSet.class)))).isEqualTo((Object)ImmutableSet.of((Object)4));
    }

    public void testSetBindingsWithGuiceModule() {
        Injector i = Guice.createInjector((Module[])new Module[]{new MultibindingGuiceModule(), DaggerAdapter.from((Object[])new Object[]{new SetBindingDaggerModule1(), new SetBindingDaggerModule2()})});
        Truth.assertThat((Iterable)((Iterable)i.getInstance((Key)new Key<Set<Integer>>(){}))).isEqualTo((Object)ImmutableSet.of((Object)13, (Object)3, (Object)5, (Object)8));
    }

    public void testUnsupportedBindingAnnotation() {
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new UnsupportedAnnotationModule()})});
            DaggerAdapterTest.fail();
        }
        catch (CreationException expected) {
            Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"noGuiceEquivalentForElementsIntoSet() is annotated with @ElementsIntoSet which is not supported by DaggerAdapter");
        }
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{UnsupportedAnnotationStaticModule.class})});
            DaggerAdapterTest.fail();
        }
        catch (CreationException expected) {
            Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"noGuiceEquivalentForElementsIntoSet() is annotated with @ElementsIntoSet which is not supported by DaggerAdapter");
        }
    }

    public void testUnsupportedBindingAnnotationFromModuleSuperclass() {
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new UnsupportedAnnotationSubclassModule()})});
            DaggerAdapterTest.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    public void testStaticProvidesMethods() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new StaticProvidesMethods()})});
        String staticProvision = (String)injector.getInstance(String.class);
        Truth.assertThat((String)staticProvision).isEqualTo((Object)"class");
    }

    public void testStaticProvidesMethods_classLiteral() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{StaticProvidesMethods.class})});
        String staticProvision = (String)injector.getInstance(String.class);
        Truth.assertThat((String)staticProvision).isEqualTo((Object)"class");
    }

    public void testStaticProvidesMethods_interface() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{StaticProvidesMethodsInterface.class})});
        String staticProvision = (String)injector.getInstance(String.class);
        Truth.assertThat((String)staticProvision).isEqualTo((Object)"interface");
    }

    public void testClassLiteralWithInstanceProvidesMethod() {
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{ModuleWithInstanceMethods.class})});
            DaggerAdapterTest.fail();
        }
        catch (CreationException expected) {
            Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"ModuleWithInstanceMethods.i() is an instance method, but a class literal was passed. Make this method static or pass an instance of the module instead.");
        }
    }

    public void testModuleObjectsMustBeDaggerModules() {
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new Object()})});
            DaggerAdapterTest.fail();
        }
        catch (CreationException expected) {
            Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"Object must be annotated with @dagger.Module");
        }
    }

    public void testProducerModulesNotSupported() {
        try {
            Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new ProducerModuleWithProvidesMethod()})});
            DaggerAdapterTest.fail();
        }
        catch (CreationException expected) {
            Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"ProducerModuleWithProvidesMethod must be annotated with @dagger.Module");
        }
    }

    public void testFilteringMethods() {
        Module filteredModule = DaggerAdapter.builder().addModules((Iterable)ImmutableList.of(ModuleWithMethodsToIgnore.class)).filter((Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return !method.getName().startsWith("ignore");
            }
        }).build();
        Injector filteredInjector = Guice.createInjector((Module[])new Module[]{filteredModule});
        Truth.assertThat((String)((String)filteredInjector.getInstance(String.class))).isEqualTo((Object)"class");
        try {
            filteredInjector.getInstance(Integer.class);
            DaggerAdapterTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            filteredInjector.getInstance(ModuleWithMethodsToIgnore.Inerface.class);
            DaggerAdapterTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        Module unfilteredModule = DaggerAdapter.builder().addModules((Iterable)ImmutableList.of(ModuleWithMethodsToIgnore.class)).build();
        Injector unfilteredInjector = Guice.createInjector((Module[])new Module[]{unfilteredModule});
        Truth.assertThat((String)((String)unfilteredInjector.getInstance(String.class))).isEqualTo((Object)"class");
        Truth.assertThat((Integer)((Integer)unfilteredInjector.getInstance(Integer.class))).isEqualTo((Object)0);
        Truth.assertThat((String)((ModuleWithMethodsToIgnore.Inerface)unfilteredInjector.getInstance(ModuleWithMethodsToIgnore.Inerface.class)).string()).isEqualTo((Object)"class");
    }

    @dagger.Module
    static abstract class ModuleWithMethodsToIgnore {
        @Binds
        abstract Inerface ignoreInterface(InterfaceImpl var1);

        @dagger.Provides
        static String string() {
            return "class";
        }

        @dagger.Provides
        static int ignore() {
            return 0;
        }

        private ModuleWithMethodsToIgnore() {
        }

        static class InterfaceImpl
        implements Inerface {
            @Inject
            InterfaceImpl() {
            }

            @Override
            public String string() {
                return "class";
            }
        }

        static interface Inerface {
            public String string();
        }
    }

    @ProducerModule
    static class ProducerModuleWithProvidesMethod {
        ProducerModuleWithProvidesMethod() {
        }

        @dagger.Provides
        int i() {
            return 1;
        }
    }

    @dagger.Module
    static class ModuleWithInstanceMethods {
        ModuleWithInstanceMethods() {
        }

        @dagger.Provides
        int i() {
            return 0;
        }
    }

    @dagger.Module
    static interface StaticProvidesMethodsInterface {
        @dagger.Provides
        public static String string() {
            return "interface";
        }
    }

    @dagger.Module
    static class StaticProvidesMethods {
        StaticProvidesMethods() {
        }

        @dagger.Provides
        static String string() {
            return "class";
        }
    }

    @dagger.Module
    static class UnsupportedAnnotationSubclassModule
    extends UnsupportedAnnotationModule {
        UnsupportedAnnotationSubclassModule() {
        }
    }

    @dagger.Module
    static class UnsupportedAnnotationStaticModule {
        UnsupportedAnnotationStaticModule() {
        }

        @dagger.Provides
        @ElementsIntoSet
        static Set<Object> noGuiceEquivalentForElementsIntoSet() {
            return ImmutableSet.of();
        }
    }

    @dagger.Module
    static class UnsupportedAnnotationModule {
        UnsupportedAnnotationModule() {
        }

        @dagger.Provides
        @ElementsIntoSet
        Set<Object> noGuiceEquivalentForElementsIntoSet() {
            return ImmutableSet.of();
        }
    }

    static class MultibindingGuiceModule
    implements Module {
        MultibindingGuiceModule() {
        }

        public void configure(Binder binder) {
            Multibinder mb = Multibinder.newSetBinder((Binder)binder, Integer.class);
            mb.addBinding().toInstance((Object)13);
            mb.addBinding().toProvider(Providers.of((Object)8));
        }
    }

    @dagger.Module
    static class SetBindingWithAnnotationDaggerModule {
        SetBindingWithAnnotationDaggerModule() {
        }

        @dagger.Provides
        @IntoSet
        @AnnotationOnSet
        Integer anInteger() {
            return 4;
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AnnotationOnSet {
    }

    @dagger.Module
    static class SetBindingDaggerModule2 {
        SetBindingDaggerModule2() {
        }

        @dagger.Provides
        @IntoSet
        Integer anInteger() {
            return 3;
        }
    }

    @dagger.Module
    static class SetBindingDaggerModule1 {
        SetBindingDaggerModule1() {
        }

        @dagger.Provides
        @IntoSet
        Integer anInteger() {
            return 5;
        }
    }

    static class SimpleGuiceModule
    extends AbstractModule {
        SimpleGuiceModule() {
        }

        @Provides
        String aString(Integer i) {
            return i.toString();
        }
    }

    @dagger.Module
    static class SimpleDaggerModule {
        SimpleDaggerModule() {
        }

        @dagger.Provides
        Integer anInteger() {
            return 1;
        }
    }
}

