/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.daggeradapter.BindingSubject;
import com.google.inject.daggeradapter.DaggerAdapter;
import dagger.Binds;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import junit.framework.TestCase;

public class BindsTest
extends TestCase {
    public void testBinds() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{BasicModule.class})});
        Binding binding = injector.getBinding(Object.class);
        BindingSubject.assertThat(binding).hasProvidedValueThat().isEqualTo((Object)"bound");
        BindingSubject.assertThat(binding).hasSource(BasicModule.class, "object", CharSequence.class);
    }

    public void testMultibindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new CountingMultibindingProviderModule(), MultibindingBindsModule.class})});
        Binding binding = injector.getBinding((Key)new Key<Set<Object>>(){});
        BindingSubject.assertThat(binding).hasProvidedValueThat().isEqualTo((Object)ImmutableSet.of((Object)"multibound-1", (Object)"multibound-2"));
        BindingSubject.assertThat(binding).hasProvidedValueThat().isEqualTo((Object)ImmutableSet.of((Object)"multibound-3", (Object)"multibound-4"));
    }

    public void testScopedMultibindings() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{new CountingMultibindingProviderModule(), ScopedMultibindingBindsModule.class})});
        Binding binding = injector.getBinding((Key)new Key<Set<Object>>(){});
        BindingSubject.assertThat(binding).hasProvidedValueThat().isEqualTo((Object)ImmutableSet.of((Object)"multibound-1", (Object)"multibound-2"));
        BindingSubject.assertThat(binding).hasProvidedValueThat().isEqualTo((Object)ImmutableSet.of((Object)"multibound-1", (Object)"multibound-2"));
    }

    public void testQualifiers() {
        Injector injector = Guice.createInjector((Module[])new Module[]{DaggerAdapter.from((Object[])new Object[]{QualifiedBinds.class})});
        Binding stringBinding = injector.getBinding(String.class);
        BindingSubject.assertThat(stringBinding).hasProvidedValueThat().isEqualTo((Object)"qualifiers");
        BindingSubject.assertThat(stringBinding).hasSource(QualifiedBinds.class, "unqualifiedToBinds", String.class);
        Binding qualifiedBinds = injector.getBinding(Key.get(String.class, BindsQualifier.class));
        BindingSubject.assertThat(qualifiedBinds).hasProvidedValueThat().isEqualTo((Object)"qualifiers");
        BindingSubject.assertThat(qualifiedBinds).hasSource(QualifiedBinds.class, "bindsToProvides", String.class);
    }

    @dagger.Module
    static interface QualifiedBinds {
        @Provides
        @ProvidesQualifier
        public static String provides() {
            return "qualifiers";
        }

        @Binds
        @BindsQualifier
        public String bindsToProvides(@ProvidesQualifier String var1);

        @Binds
        public String unqualifiedToBinds(@BindsQualifier String var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface BindsQualifier {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface ProvidesQualifier {
    }

    @dagger.Module
    static interface ScopedMultibindingBindsModule {
        @Binds
        @IntoSet
        @Singleton
        public Object fromString(String var1);

        @Binds
        public CharSequence toCharSequence(String var1);

        @Binds
        @IntoSet
        @Singleton
        public Object fromCharSequence(CharSequence var1);
    }

    @dagger.Module
    static interface MultibindingBindsModule {
        @Binds
        @IntoSet
        public Object fromString(String var1);

        @Binds
        public CharSequence toCharSequence(String var1);

        @Binds
        @IntoSet
        public Object fromCharSequence(CharSequence var1);
    }

    @dagger.Module
    static class CountingMultibindingProviderModule {
        int count = 0;

        CountingMultibindingProviderModule() {
        }

        @Provides
        String provider() {
            ++this.count;
            return "multibound-" + this.count;
        }
    }

    @dagger.Module
    static interface BasicModule {
        @Provides
        public static String string() {
            return "bound";
        }

        @Binds
        public CharSequence charSequence(String var1);

        @Binds
        public Object object(CharSequence var1);
    }
}

