/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.daggeradapter;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.inject.Binding;
import com.google.inject.spi.ElementSource;
import java.lang.reflect.Method;
import java.util.Arrays;

final class BindingSubject
extends Subject {
    private final Binding<?> actual;

    static BindingSubject assertThat(Binding<?> binding) {
        return (BindingSubject)Truth.assert_().about(BindingSubject::new).that(binding);
    }

    private BindingSubject(FailureMetadata metadata, Binding<?> actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    void hasSource(Class<?> moduleClass, String moduleMethod, Class<?> ... moduleMethodArgs) {
        Method method;
        try {
            method = moduleClass.getDeclaredMethod(moduleMethod, moduleMethodArgs);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError(String.format("Expected %s.%s(%s) to exist", moduleClass.getSimpleName(), moduleMethod, Arrays.toString(moduleMethodArgs)), e);
        }
        Object source = this.actual.getSource();
        if (source instanceof ElementSource) {
            source = ((ElementSource)source).getDeclaringSource();
        }
        if (!source.equals(method)) {
            this.failWithoutActual(Fact.fact((String)"source", (Object)method), new Fact[0]);
        }
    }

    Subject hasProvidedValueThat() {
        return this.check("provided value", new Object[0]).that(this.actual.getProvider().get());
    }
}

