/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.web.WebResponse;
import io.fluxcapacitor.javaclient.web.WebResponseMapper;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;

public class WebResponseGateway
implements ResultGateway {
    private final GatewayClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final WebResponseMapper webResponseMapper;

    @Override
    public CompletableFuture<Void> respond(Object payload, Metadata metadata, String target, Integer requestId, Guarantee guarantee) {
        return this.respond(this.webResponseMapper.map(payload, metadata), target, requestId, guarantee);
    }

    private CompletableFuture<Void> respond(WebResponse response, String target, Integer requestId, Guarantee guarantee) {
        try {
            SerializedMessage serializedMessage = this.interceptDispatch(response);
            if (serializedMessage == null) {
                return CompletableFuture.completedFuture(null);
            }
            serializedMessage.setTarget(target);
            serializedMessage.setRequestId(requestId);
            return this.client.send(guarantee, serializedMessage);
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send response %s", (Object[])response.getPayload()), e);
        }
    }

    protected SerializedMessage interceptDispatch(WebResponse response) {
        Message message = this.dispatchInterceptor.interceptDispatch(response, MessageType.WEBRESPONSE);
        return message == null ? null : this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.WEBRESPONSE);
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "webResponseMapper"})
    public WebResponseGateway(GatewayClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, WebResponseMapper webResponseMapper) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.webResponseMapper = webResponseMapper;
    }
}

