/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebParameters;
import io.fluxcapacitor.javaclient.web.WebUtils;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.net.HttpCookie;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class WebRequest
extends Message {
    private static final Map<Executable, Predicate<HasMessage>> filterCache = new ConcurrentHashMap<Executable, Predicate<HasMessage>>();
    @NonNull
    private final String path;
    @NonNull
    private final HttpRequestMethod method;
    @NonNull
    private final Map<String, List<String>> headers;
    @JsonIgnore
    private final AtomicReference<Object> cookies = new AtomicReference();

    public static Builder builder() {
        return new Builder();
    }

    public static MessageFilter<HasMessage> getWebRequestFilter() {
        return (message, executable) -> filterCache.computeIfAbsent(executable, e -> {
            WebParameters handleWeb = WebUtils.getWebParameters(e).orElseThrow();
            Predicate<String> pathTest = Optional.of(handleWeb.getPath()).map(SearchUtils::getGlobMatcher).map(p -> s -> p.test(s.startsWith("/") || s.contains("://") ? s : "/" + s)).orElse(p -> true);
            Predicate<String> methodTest = Optional.of(handleWeb.getMethod()).map(r -> p -> r.name().equals(p)).orElse(p -> true);
            return msg -> {
                String path = Objects.requireNonNull(msg.getMetadata().get((Object)"url"), "Web request url is missing in the metadata of a WebRequest message");
                String method = Objects.requireNonNull(msg.getMetadata().get((Object)"method"), "Web request method is missing in the metadata of a WebRequest message");
                return pathTest.test(path) && methodTest.test(method);
            };
        }).test(message);
    }

    private WebRequest(Builder builder) {
        super(builder.payload(), Metadata.of((Object[])new Object[]{"url", builder.url(), "method", builder.method().name(), "headers", builder.headers()}));
        this.path = builder.url();
        this.method = builder.method();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebRequest(Object payload, Metadata metadata, String messageId, Instant timestamp) {
        super(payload, metadata, messageId, timestamp);
        this.path = WebRequest.getUrl(metadata);
        this.method = WebRequest.getMethod(metadata);
        this.headers = WebRequest.getHeaders(metadata);
    }

    public WebRequest(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getPayload(), (String)format), this.getMetadata(), this.getMessageId(), Long.valueOf(this.getTimestamp().toEpochMilli()))).orElseGet(() -> super.serialize(serializer));
    }

    @Override
    public WebRequest withMetadata(Metadata metadata) {
        return new WebRequest(super.withMetadata(metadata));
    }

    @Override
    public WebRequest addMetadata(Metadata metadata) {
        return (WebRequest)super.addMetadata(metadata);
    }

    @Override
    public WebRequest addMetadata(String key, Object value) {
        return (WebRequest)super.addMetadata(key, value);
    }

    @Override
    public WebRequest addMetadata(Object ... keyValues) {
        return (WebRequest)super.addMetadata(keyValues);
    }

    @Override
    public WebRequest addMetadata(Map<String, ?> values) {
        return (WebRequest)super.addMetadata(values);
    }

    @Override
    public WebRequest addUser(User user) {
        return (WebRequest)super.addUser(user);
    }

    @Override
    public WebRequest withPayload(Object payload) {
        return this.toBuilder().payload(payload).build();
    }

    public String getHeader(String name) {
        return this.getHeaders(name).stream().findFirst().orElse(null);
    }

    public List<String> getHeaders(String name) {
        return this.headers.getOrDefault(name, Collections.emptyList());
    }

    public Optional<HttpCookie> getCookie(String name) {
        return this.getCookies().stream().filter(c -> Objects.equals(name, c.getName())).findFirst();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static String getUrl(Metadata metadata) {
        return Optional.ofNullable(metadata.get((Object)"url")).map(u -> u.startsWith("/") || u.contains("://") ? u : "/" + u).orElseThrow(() -> new IllegalStateException("WebRequest is malformed: url is missing"));
    }

    public static HttpRequestMethod getMethod(Metadata metadata) {
        return Optional.ofNullable(metadata.get((Object)"method")).map(m -> {
            try {
                return HttpRequestMethod.valueOf(m);
            }
            catch (Exception e) {
                throw new IllegalStateException("WebRequest is malformed: unrecognized http method");
            }
        }).orElseThrow(() -> new IllegalStateException("WebRequest is malformed: http method is missing"));
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata) {
        return Optional.ofNullable((Map)metadata.get((Object)"headers", Map.class)).orElse(Collections.emptyMap());
    }

    public static Optional<HttpCookie> getCookie(Metadata metadata, String name) {
        return WebRequest.getHeaders(metadata).getOrDefault("Cookie", Collections.emptyList()).stream().findFirst().map(WebUtils::parseRequestCookieHeader).orElseGet(Collections::emptyList).stream().filter(c -> Objects.equals(c.getName(), name)).findFirst();
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public HttpRequestMethod getMethod() {
        return this.method;
    }

    @NonNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebRequest)) {
            return false;
        }
        WebRequest other = (WebRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        HttpRequestMethod this$method = this.getMethod();
        HttpRequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<HttpCookie> this$cookies = this.getCookies();
        List<HttpCookie> other$cookies = other.getCookies();
        return !(this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        HttpRequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<HttpCookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebRequest(path=" + this.getPath() + ", method=" + this.getMethod() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpCookie> getCookies() {
        Object value = this.cookies.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.cookies;
            synchronized (atomicReference) {
                value = this.cookies.get();
                if (value == null) {
                    List actualValue = Optional.ofNullable(this.getHeader("Cookie")).map(WebUtils::parseRequestCookieHeader).orElse(Collections.emptyList());
                    value = actualValue == null ? this.cookies : actualValue;
                    this.cookies.set(value);
                }
            }
        }
        return (List)(value == this.cookies ? null : value);
    }

    public static class Builder {
        private String url;
        private HttpRequestMethod method;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        private boolean acceptGzipEncoding = true;
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();
        private Object payload;

        protected Builder(WebRequest request) {
            this.method(request.getMethod());
            this.url(request.getPath());
            this.payload(request.getPayload());
            request.getHeaders().forEach((k, v) -> this.headers.put((String)k, new ArrayList(v)));
            this.cookies.addAll(WebUtils.parseRequestCookieHeader(Optional.ofNullable(this.headers.remove("Cookie")).orElseGet(List::of).stream().findFirst().orElse(null)));
        }

        public Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder cookie(HttpCookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Builder payload(Object payload) {
            this.payload = payload;
            return this;
        }

        public Map<String, List<String>> headers() {
            LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(this.headers);
            if (this.acceptGzipEncoding) {
                result.computeIfAbsent("Accept-Encoding", k -> List.of("gzip"));
            }
            if (!result.containsKey("Content-Type")) {
                if (this.payload instanceof String) {
                    result.put("Content-Type", List.of("text/plain"));
                } else if (this.payload instanceof byte[]) {
                    result.put("Content-Type", List.of("application/octet-stream"));
                }
            }
            if (!this.cookies.isEmpty()) {
                result.put("Cookie", List.of(this.cookies.stream().map(HttpCookie::toString).collect(Collectors.joining("; "))));
            }
            return result;
        }

        public WebRequest build() {
            if (this.method == null) {
                throw new IllegalStateException("HTTP request method not set");
            }
            return new WebRequest(this);
        }

        public String url() {
            return this.url;
        }

        public HttpRequestMethod method() {
            return this.method;
        }

        public boolean acceptGzipEncoding() {
            return this.acceptGzipEncoding;
        }

        public List<HttpCookie> cookies() {
            return this.cookies;
        }

        public Object payload() {
            return this.payload;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(HttpRequestMethod method) {
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder acceptGzipEncoding(boolean acceptGzipEncoding) {
            this.acceptGzipEncoding = acceptGzipEncoding;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.acceptGzipEncoding() != other.acceptGzipEncoding()) {
                return false;
            }
            String this$url = this.url();
            String other$url = other.url();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            HttpRequestMethod this$method = this.method();
            HttpRequestMethod other$method = other.method();
            if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<HttpCookie> this$cookies = this.cookies();
            List<HttpCookie> other$cookies = other.cookies();
            if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.acceptGzipEncoding() ? 79 : 97);
            String $url = this.url();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            HttpRequestMethod $method = this.method();
            result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<HttpCookie> $cookies = this.cookies();
            result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
            Object $payload = this.payload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "WebRequest.Builder(url=" + this.url() + ", method=" + this.method() + ", headers=" + this.headers() + ", acceptGzipEncoding=" + this.acceptGzipEncoding() + ", cookies=" + this.cookies() + ", payload=" + this.payload() + ")";
        }

        public Builder() {
        }
    }
}

