/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSelf;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHandlerRegistry
implements HandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(LocalHandlerRegistry.class);
    private final MessageType messageType;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();
    private final HandlerFilter handleSelfFilter = (c, e) -> ReflectionUtils.getAnnotation((Executable)e, HandleSelf.class).map(h -> !h.disabled()).orElse(false);
    private final Function<Class<?>, Optional<Handler<DeserializingMessage>>> selfHandlers = ObjectUtils.memoize(this::computeSelfHandler);

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        if (target instanceof Handler) {
            this.localHandlers.add((Handler<DeserializingMessage>)((Handler)target));
            return () -> this.localHandlers.remove(target);
        }
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(ReflectionUtils.asInstance((Object)target), "local-" + this.messageType, handlerFilter, Collections.emptyList());
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    @Override
    public Optional<CompletableFuture<Message>> handle(DeserializingMessage message) {
        if (!this.localHandlers.isEmpty() || this.handleSelf(message)) {
            List<Handler<DeserializingMessage>> localHandlers = this.getLocalHandlers(message);
            return message.apply(m -> {
                boolean handled = false;
                boolean logMessage = false;
                boolean request = m.getMessageType().isRequest();
                CompletionStage<Message> future = new CompletableFuture<Message>();
                for (Handler handler : localHandlers) {
                    Optional optionalInvoker = handler.findInvoker(m);
                    if (!optionalInvoker.isPresent()) continue;
                    HandlerInvoker invoker = (HandlerInvoker)optionalInvoker.get();
                    boolean passive = invoker.isPassive();
                    if (handled && request && !passive) continue;
                    try {
                        Object result = Invocation.performInvocation(() -> ((HandlerInvoker)invoker).invoke());
                        if (!passive && !future.isDone()) {
                            if (result instanceof CompletableFuture) {
                                future = ((CompletableFuture)result).thenApply(Message::new);
                            } else {
                                future.complete(new Message(result));
                            }
                        }
                        if (!passive) {
                            handled = true;
                        }
                        logMessage = logMessage || this.logMessage(invoker);
                    }
                    catch (Throwable e) {
                        try {
                            if (passive) {
                                log.error("Passive handler {} failed to handle a {}", new Object[]{invoker, m.getPayloadClass(), e});
                            } else {
                                future.completeExceptionally(e);
                            }
                            if (!passive) {
                                handled = true;
                            }
                            logMessage = logMessage || this.logMessage(invoker);
                        }
                        catch (Throwable throwable) {
                            if (!passive) {
                                handled = true;
                            }
                            logMessage = logMessage || this.logMessage(invoker);
                            throw throwable;
                        }
                    }
                }
                try {
                    Optional optional = handled ? Optional.of(future) : Optional.empty();
                    return optional;
                }
                finally {
                    if (logMessage) {
                        FluxCapacitor.getOptionally().ifPresent(fc -> fc.client().getGatewayClient(m.getMessageType()).send(Guarantee.NONE, message.getSerializedObject()));
                    }
                }
            });
        }
        return Optional.empty();
    }

    protected boolean handleSelf(DeserializingMessage message) {
        return this.messageType.isRequest() && ClientUtils.getHandleSelfAnnotation(message.getPayloadClass()).isPresent();
    }

    protected List<Handler<DeserializingMessage>> getLocalHandlers(DeserializingMessage message) {
        if (!message.getMessageType().isRequest()) {
            return this.localHandlers;
        }
        return message.apply(m -> this.selfHandlers.apply(m.getPayloadClass()).map(h -> Stream.concat(this.localHandlers.stream(), Stream.of(h)).toList()).orElse(this.localHandlers));
    }

    protected boolean logMessage(HandlerInvoker invoker) {
        Annotation annotation = invoker.getMethodAnnotation();
        if (annotation instanceof HandleSelf) {
            HandleSelf handleSelf = (HandleSelf)annotation;
            return handleSelf.logMessage();
        }
        return ClientUtils.getLocalHandlerAnnotation(invoker.getTarget().getClass(), invoker.getMethod()).map(LocalHandler::logMessage).orElse(false);
    }

    protected Optional<Handler<DeserializingMessage>> computeSelfHandler(Class<?> payloadType) {
        return this.handlerFactory.createHandler(() -> DeserializingMessage.getCurrent().getPayload(), payloadType, HandleSelf.class, "self-" + this.messageType, this.handleSelfFilter, Collections.emptyList());
    }

    @ConstructorProperties(value={"messageType", "handlerFactory"})
    public LocalHandlerRegistry(MessageType messageType, HandlerFactory handlerFactory) {
        this.messageType = messageType;
        this.handlerFactory = handlerFactory;
    }
}

