/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface HandlerInterceptor
extends HandlerDecorator {
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> var1, HandlerInvoker var2);

    @Override
    default public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler) {
        return new InterceptedHandler(handler, this);
    }

    public static class InterceptedHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;
        private final HandlerInterceptor interceptor;

        public Optional<HandlerInvoker> findInvoker(final DeserializingMessage message) {
            Optional invoker = this.delegate.findInvoker((Object)message);
            return invoker.map(s -> new HandlerInvoker.DelegatingHandlerInvoker((HandlerInvoker)s, (HandlerInvoker)s){
                final /* synthetic */ HandlerInvoker val$s;
                {
                    this.val$s = handlerInvoker;
                    super(delegate);
                }

                public Object invoke(BiFunction<Object, Object, Object> combiner) {
                    return interceptor.interceptHandling(m -> {
                        if (m != message) {
                            HandlerInvoker i = (HandlerInvoker)delegate.findInvoker(m).orElseThrow(() -> new UnsupportedOperationException("Changing the payload type in a HandlerInterceptor is not supported."));
                            return m.apply(msg -> i.invoke(combiner));
                        }
                        return this.val$s.invoke(combiner);
                    }, this.val$s).apply(message);
                }
            });
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate", "interceptor"})
        public InterceptedHandler(Handler<DeserializingMessage> delegate, HandlerInterceptor interceptor) {
            this.delegate = delegate;
            this.interceptor = interceptor;
        }

        public Object getTarget() {
            return this.delegate.getTarget();
        }

        private static interface ExcludedMethods {
            public Optional<HandlerInvoker> findInvoker(DeserializingMessage var1);
        }
    }
}

