/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.HandleWebResponse;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DefaultHandlerFactory
implements HandlerFactory {
    private final MessageType messageType;
    private final HandlerDecorator defaultDecorator;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final MessageFilter<? super DeserializingMessage> messageFilter;

    public static Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
        return switch (messageType) {
            default -> throw new IncompatibleClassChangeError();
            case MessageType.COMMAND -> HandleCommand.class;
            case MessageType.EVENT -> HandleEvent.class;
            case MessageType.NOTIFICATION -> HandleNotification.class;
            case MessageType.QUERY -> HandleQuery.class;
            case MessageType.RESULT -> HandleResult.class;
            case MessageType.ERROR -> HandleError.class;
            case MessageType.SCHEDULE -> HandleSchedule.class;
            case MessageType.METRICS -> HandleMetrics.class;
            case MessageType.WEBREQUEST -> HandleWeb.class;
            case MessageType.WEBRESPONSE -> HandleWebResponse.class;
        };
    }

    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.messageFilter = this.computeMessageFilter();
    }

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Object target, String consumer, HandlerFilter handlerFilter, List<HandlerInterceptor> extraInterceptors) {
        return this.createHandler(() -> target, target.getClass(), DefaultHandlerFactory.getHandlerAnnotation(this.messageType), consumer, handlerFilter, extraInterceptors);
    }

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Supplier<?> targetSupplier, Class<?> targetClass, Class<? extends Annotation> handlerAnnotation, String consumer, HandlerFilter handlerFilter, List<HandlerInterceptor> extraInterceptors) {
        HandlerDecorator interceptor = Stream.concat(Stream.of(this.defaultDecorator), extraInterceptors.stream()).reduce(HandlerDecorator::andThen).orElseThrow();
        return Optional.ofNullable(handlerAnnotation).map(a -> HandlerConfiguration.builder().methodAnnotation(a).handlerFilter(handlerFilter).messageFilter(this.messageFilter).build()).filter(config -> HandlerInspector.hasHandlerMethods((Class)targetClass, (HandlerConfiguration)config)).map(config -> HandlerInspector.createHandler((Supplier)targetSupplier, (Class)targetClass, this.parameterResolvers, (HandlerConfiguration)config)).map(handler -> interceptor.wrap((Handler<DeserializingMessage>)handler));
    }

    protected MessageFilter<? super DeserializingMessage> computeMessageFilter() {
        MessageFilter result = this.parameterResolvers.stream().flatMap(r -> r instanceof MessageFilter ? Stream.of((MessageFilter)r) : Stream.empty()).reduce(MessageFilter::and).orElseGet(() -> (m, a) -> true);
        return this.messageType == MessageType.WEBREQUEST ? WebRequest.getWebRequestFilter().and(result) : result;
    }

    @ConstructorProperties(value={"messageType", "defaultDecorator", "parameterResolvers", "messageFilter"})
    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, MessageFilter<? super DeserializingMessage> messageFilter) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.messageFilter = messageFilter;
    }
}

