/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.TrackerRead;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class SimpleTrackerRead
implements TrackerRead {
    private final String consumer;
    private final String trackerId;
    private final Long lastIndex;
    private final long deadline;
    private final Long purgeTimeout;
    private final int maxSize;
    private final Predicate<String> typeFilter;
    private final boolean filterMessageTarget;
    private final MessageType messageType;

    public SimpleTrackerRead(String consumer, String trackerId, Long previousLastIndex, ConsumerConfiguration config, MessageType messageType) {
        this.consumer = consumer;
        this.trackerId = trackerId;
        this.lastIndex = previousLastIndex;
        this.deadline = System.currentTimeMillis() + config.getMaxWaitDuration().toMillis();
        this.purgeTimeout = Optional.ofNullable(config.getPurgeDelay()).map(Duration::toMillis).orElse(null);
        this.maxSize = config.getMaxFetchSize();
        this.typeFilter = SimpleTrackerRead.toPredicate(config.getTypeFilter());
        this.filterMessageTarget = config.filterMessageTarget();
        this.messageType = messageType;
    }

    private static Predicate<String> toPredicate(String typeFilter) {
        if (typeFilter == null) {
            return s -> true;
        }
        return Pattern.compile(typeFilter).asMatchPredicate();
    }

    @Override
    public boolean canHandle(SerializedMessage message) {
        return message.getData().getType() == null || this.typeFilter.test(message.getData().getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTrackerRead that = (SimpleTrackerRead)o;
        return Objects.equals(this.consumer, that.consumer) && Objects.equals(this.trackerId, that.trackerId);
    }

    public int hashCode() {
        return Objects.hash(this.consumer, this.trackerId);
    }

    public String toString() {
        return "SimpleTrackerRead{consumerName='" + this.consumer + "', trackerId='" + this.trackerId + "'}";
    }

    @Override
    public String getConsumer() {
        return this.consumer;
    }

    @Override
    public String getTrackerId() {
        return this.trackerId;
    }

    @Override
    public Long getLastIndex() {
        return this.lastIndex;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public Long getPurgeTimeout() {
        return this.purgeTimeout;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public Predicate<String> getTypeFilter() {
        return this.typeFilter;
    }

    public boolean isFilterMessageTarget() {
        return this.filterMessageTarget;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }
}

