/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StallingBatchInterceptor
implements BatchInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StallingBatchInterceptor.class);
    private final int desiredBatchSize;
    @NonNull
    private final Duration maximumStallingDuration;
    @NonNull
    private final Duration retryFrequency;
    private final AtomicReference<Instant> firstRefusal = new AtomicReference();

    @Override
    public Consumer<MessageBatch> intercept(Consumer<MessageBatch> consumer, Tracker tracker) {
        return b -> {
            if (b.getSize() >= this.desiredBatchSize || this.hasPassedDeadline()) {
                consumer.accept((MessageBatch)b);
                this.firstRefusal.set(null);
            } else {
                this.stall();
            }
        };
    }

    protected boolean hasPassedDeadline() {
        return Optional.ofNullable(this.firstRefusal.get()).filter(f -> !FluxCapacitor.currentTime().isBefore(f.plus(this.maximumStallingDuration))).isPresent();
    }

    protected void stall() {
        this.firstRefusal.updateAndGet(f -> f == null ? FluxCapacitor.currentTime() : f);
        try {
            Thread.sleep(this.retryFrequency.toMillis());
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private static int $default$desiredBatchSize() {
        return 512;
    }

    private static Duration $default$maximumStallingDuration() {
        return Duration.ofSeconds(60L);
    }

    private static Duration $default$retryFrequency() {
        return Duration.ofSeconds(1L);
    }

    @ConstructorProperties(value={"desiredBatchSize", "maximumStallingDuration", "retryFrequency"})
    StallingBatchInterceptor(int desiredBatchSize, @NonNull Duration maximumStallingDuration, @NonNull Duration retryFrequency) {
        if (maximumStallingDuration == null) {
            throw new NullPointerException("maximumStallingDuration is marked non-null but is null");
        }
        if (retryFrequency == null) {
            throw new NullPointerException("retryFrequency is marked non-null but is null");
        }
        this.desiredBatchSize = desiredBatchSize;
        this.maximumStallingDuration = maximumStallingDuration;
        this.retryFrequency = retryFrequency;
    }

    public static StallingBatchInterceptorBuilder builder() {
        return new StallingBatchInterceptorBuilder();
    }

    public static class StallingBatchInterceptorBuilder {
        private boolean desiredBatchSize$set;
        private int desiredBatchSize$value;
        private boolean maximumStallingDuration$set;
        private Duration maximumStallingDuration$value;
        private boolean retryFrequency$set;
        private Duration retryFrequency$value;

        StallingBatchInterceptorBuilder() {
        }

        public StallingBatchInterceptorBuilder desiredBatchSize(int desiredBatchSize) {
            this.desiredBatchSize$value = desiredBatchSize;
            this.desiredBatchSize$set = true;
            return this;
        }

        public StallingBatchInterceptorBuilder maximumStallingDuration(@NonNull Duration maximumStallingDuration) {
            if (maximumStallingDuration == null) {
                throw new NullPointerException("maximumStallingDuration is marked non-null but is null");
            }
            this.maximumStallingDuration$value = maximumStallingDuration;
            this.maximumStallingDuration$set = true;
            return this;
        }

        public StallingBatchInterceptorBuilder retryFrequency(@NonNull Duration retryFrequency) {
            if (retryFrequency == null) {
                throw new NullPointerException("retryFrequency is marked non-null but is null");
            }
            this.retryFrequency$value = retryFrequency;
            this.retryFrequency$set = true;
            return this;
        }

        public StallingBatchInterceptor build() {
            int desiredBatchSize$value = this.desiredBatchSize$value;
            if (!this.desiredBatchSize$set) {
                desiredBatchSize$value = StallingBatchInterceptor.$default$desiredBatchSize();
            }
            Duration maximumStallingDuration$value = this.maximumStallingDuration$value;
            if (!this.maximumStallingDuration$set) {
                maximumStallingDuration$value = StallingBatchInterceptor.$default$maximumStallingDuration();
            }
            Duration retryFrequency$value = this.retryFrequency$value;
            if (!this.retryFrequency$set) {
                retryFrequency$value = StallingBatchInterceptor.$default$retryFrequency();
            }
            return new StallingBatchInterceptor(desiredBatchSize$value, maximumStallingDuration$value, retryFrequency$value);
        }

        public String toString() {
            return "StallingBatchInterceptor.StallingBatchInterceptorBuilder(desiredBatchSize$value=" + this.desiredBatchSize$value + ", maximumStallingDuration$value=" + this.maximumStallingDuration$value + ", retryFrequency$value=" + this.retryFrequency$value + ")";
        }
    }
}

