/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.scheduling.CancelSchedule;
import io.fluxcapacitor.common.api.scheduling.GetSchedule;
import io.fluxcapacitor.common.api.scheduling.GetScheduleResult;
import io.fluxcapacitor.common.api.scheduling.Schedule;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;

@ClientEndpoint
public class WebsocketSchedulingClient
extends AbstractWebsocketClient
implements SchedulingClient {
    public WebsocketSchedulingClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), clientConfig);
    }

    public WebsocketSchedulingClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig) {
        this(endpointUri, clientConfig, true);
    }

    public WebsocketSchedulingClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics) {
        super(endpointUri, clientConfig, sendMetrics, clientConfig.getGatewaySessions().get(MessageType.SCHEDULE));
    }

    @Override
    public CompletableFuture<Void> schedule(Guarantee guarantee, SerializedSchedule ... schedules) {
        return this.sendCommand((Command)new Schedule(Arrays.asList(schedules), guarantee));
    }

    @Override
    public CompletableFuture<Void> cancelSchedule(String scheduleId, Guarantee guarantee) {
        return this.sendCommand((Command)new CancelSchedule(scheduleId, guarantee));
    }

    @Override
    public SerializedSchedule getSchedule(String scheduleId) {
        return ((GetScheduleResult)this.sendAndWait((Request)new GetSchedule(scheduleId))).getSchedule();
    }
}

