/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.CronExpression;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;

public interface Scheduler {
    default public String schedule(Object schedule, Instant deadline) {
        String scheduleId = FluxCapacitor.currentIdentityProvider().nextTechnicalId();
        this.schedule(schedule, scheduleId, deadline);
        return scheduleId;
    }

    default public String schedule(Object schedule, Duration delay) {
        return this.schedule(schedule, FluxCapacitor.currentTime().plus(delay));
    }

    default public String schedule(Object schedule, String cronSchedule) {
        return this.schedule(schedule, Scheduler.nextDeadline(cronSchedule));
    }

    default public void schedule(Object schedule, String scheduleId, Duration delay) {
        this.schedule(schedule, scheduleId, FluxCapacitor.currentTime().plus(delay));
    }

    default public void schedule(Object schedule, String scheduleId, String cronSchedule) {
        this.schedule(schedule, scheduleId, Scheduler.nextDeadline(cronSchedule));
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, Instant deadline) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, deadline);
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, Duration delay) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, delay);
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, String cronSchedule) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, Scheduler.nextDeadline(cronSchedule));
    }

    default public void schedule(Object schedule, String scheduleId, Instant deadline) {
        if (schedule instanceof Message) {
            Message message = (Message)schedule;
            this.schedule(new Schedule(message.getPayload(), message.getMetadata(), message.getMessageId(), message.getTimestamp(), scheduleId, deadline));
        } else {
            this.schedule(new Schedule(schedule, scheduleId, deadline));
        }
    }

    default public void schedule(Schedule message) {
        this.schedule(message, false);
    }

    public void schedule(Schedule var1, boolean var2);

    default public String scheduleCommand(Object schedule, Instant deadline) {
        String scheduleId = FluxCapacitor.currentIdentityProvider().nextTechnicalId();
        this.scheduleCommand(schedule, scheduleId, deadline);
        return scheduleId;
    }

    default public String scheduleCommand(Object schedule, Duration delay) {
        return this.scheduleCommand(schedule, FluxCapacitor.currentTime().plus(delay));
    }

    default public String scheduleCommand(Object schedule, String cronSchedule) {
        return this.scheduleCommand(schedule, Scheduler.nextDeadline(cronSchedule));
    }

    default public void scheduleCommand(Object schedule, String scheduleId, Duration delay) {
        this.scheduleCommand(schedule, scheduleId, FluxCapacitor.currentTime().plus(delay));
    }

    default public void scheduleCommand(Object schedule, String scheduleId, String cronSchedule) {
        this.scheduleCommand(schedule, scheduleId, Scheduler.nextDeadline(cronSchedule));
    }

    default public void scheduleCommand(Object schedulePayload, Metadata metadata, String scheduleId, Instant deadline) {
        this.scheduleCommand((Object)new Message(schedulePayload, metadata), scheduleId, deadline);
    }

    default public void scheduleCommand(Object schedulePayload, Metadata metadata, String scheduleId, Duration delay) {
        this.scheduleCommand((Object)new Message(schedulePayload, metadata), scheduleId, delay);
    }

    default public void scheduleCommand(Object schedulePayload, Metadata metadata, String scheduleId, String cronSchedule) {
        this.scheduleCommand((Object)new Message(schedulePayload, metadata), scheduleId, Scheduler.nextDeadline(cronSchedule));
    }

    default public void scheduleCommand(Object schedule, String scheduleId, Instant deadline) {
        if (schedule instanceof Message) {
            Message message = (Message)schedule;
            this.scheduleCommand(new Schedule(message.getPayload(), message.getMetadata(), message.getMessageId(), message.getTimestamp(), scheduleId, deadline));
        } else {
            this.scheduleCommand(new Schedule(schedule, scheduleId, deadline));
        }
    }

    default public void scheduleCommand(Schedule message) {
        this.scheduleCommand(message, false);
    }

    public void scheduleCommand(Schedule var1, boolean var2);

    public void cancelSchedule(String var1);

    public Optional<Schedule> getSchedule(String var1);

    private static Instant nextDeadline(String cronSchedule) {
        return CronExpression.parseCronExpression(cronSchedule).nextTimeAfter(FluxCapacitor.currentTime().atZone(ZoneId.of("UTC"))).toInstant();
    }
}

