/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.ScheduledCommand;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultScheduler
implements Scheduler {
    private final SchedulingClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final DispatchInterceptor commandDispatchInterceptor;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void schedule(Schedule message, boolean ifAbsent) {
        try {
            if (Entity.isLoading()) {
                return;
            }
            if ((message = (Schedule)this.dispatchInterceptor.interceptDispatch(message, MessageType.SCHEDULE)) == null) {
                return;
            }
            SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.SCHEDULE);
            if (serializedMessage == null) {
                return;
            }
            this.client.schedule(new SerializedSchedule(message.getScheduleId(), message.getDeadline().toEpochMilli(), serializedMessage, ifAbsent)).get();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to schedule message %s for %s", message.getPayload(), message.getDeadline()), e);
        }
    }

    @Override
    public void scheduleCommand(Schedule schedule, boolean ifAbsent) {
        Message intercepted = this.commandDispatchInterceptor.interceptDispatch(schedule, MessageType.COMMAND);
        if (intercepted == null) {
            return;
        }
        SerializedMessage serializedCommand = this.commandDispatchInterceptor.modifySerializedMessage((schedule = schedule.withPayload(intercepted.getPayload()).withMetadata(intercepted.getMetadata())).serialize(this.serializer), schedule, MessageType.COMMAND);
        if (serializedCommand == null) {
            return;
        }
        this.schedule(schedule.withPayload(new ScheduledCommand(serializedCommand)).addMetadata("$commandType", (Object)schedule.getPayloadClass().getName()), ifAbsent);
    }

    @Override
    public void cancelSchedule(String scheduleId) {
        try {
            if (Entity.isLoading()) {
                return;
            }
            this.client.cancelSchedule(scheduleId).get();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to cancel schedule with id %s", scheduleId), e);
        }
    }

    @Override
    public Optional<Schedule> getSchedule(String scheduleId) {
        return Optional.ofNullable(this.client.getSchedule(scheduleId)).flatMap(s -> this.serializer.deserializeMessages(Stream.of(s.getMessage()), MessageType.SCHEDULE).findFirst().map(DeserializingMessage::toMessage).map(m -> new Schedule(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp(), s.getScheduleId(), Instant.ofEpochMilli(s.getTimestamp()))));
    }

    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }

    public void handleLocally(Schedule schedule) {
        SerializedMessage serializedMessage = schedule.serialize(this.serializer);
        serializedMessage.setIndex(Long.valueOf(IndexUtils.indexFromTimestamp(schedule.getDeadline())));
        this.localHandlerRegistry.handle(new DeserializingMessage(serializedMessage, type -> this.serializer.convert(schedule.getPayload(), type), MessageType.SCHEDULE));
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "commandDispatchInterceptor", "localHandlerRegistry"})
    public DefaultScheduler(SchedulingClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, DispatchInterceptor commandDispatchInterceptor, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.commandDispatchInterceptor = commandDispatchInterceptor;
        this.localHandlerRegistry = localHandlerRegistry;
    }
}

