/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.publishing.Append;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.client.MessageDispatch;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

@ClientEndpoint
public class WebsocketGatewayClient
extends AbstractWebsocketClient
implements GatewayClient {
    private final Set<Consumer<MessageDispatch>> monitors = new CopyOnWriteArraySet<Consumer<MessageDispatch>>();
    private final Metadata metricsMetadata;
    private final MessageType messageType;

    public WebsocketGatewayClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        this(URI.create(endPointUrl), clientConfig, type);
    }

    public WebsocketGatewayClient(URI endPointUri, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        this(endPointUri, clientConfig, type, type != MessageType.METRICS);
    }

    public WebsocketGatewayClient(URI endPointUri, WebSocketClient.ClientConfig clientConfig, MessageType type, boolean sendMetrics) {
        super(endPointUri, clientConfig, sendMetrics, clientConfig.getGatewaySessions().get(type));
        this.metricsMetadata = Metadata.of((Object)"messageType", (Object)type);
        this.messageType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> send(Guarantee guarantee, SerializedMessage ... messages) {
        try {
            CompletableFuture<Void> completableFuture = this.sendCommand((Command)new Append(Arrays.asList(messages), guarantee));
            return completableFuture;
        }
        finally {
            if (!this.monitors.isEmpty()) {
                MessageDispatch dispatch = new MessageDispatch(Arrays.asList(messages), this.messageType);
                this.monitors.forEach(m -> m.accept(dispatch));
            }
        }
    }

    @Override
    protected Metadata metricsMetadata() {
        return this.metricsMetadata;
    }

    public Registration registerMonitor(Consumer<MessageDispatch> monitor) {
        this.monitors.add(monitor);
        return () -> this.monitors.remove(monitor);
    }
}

