/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.TimeoutException;
import io.fluxcapacitor.javaclient.publishing.WebRequestGateway;
import io.fluxcapacitor.javaclient.tracking.handling.Request;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebRequestSettings;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class DefaultWebRequestGateway
implements WebRequestGateway {
    private final GenericGateway delegate;

    @Override
    public CompletableFuture<Void> sendAndForget(Guarantee guarantee, WebRequest ... requests) {
        return this.delegate.sendAndForget(guarantee, requests);
    }

    @Override
    public CompletableFuture<WebResponse> send(WebRequest request) {
        return this.delegate.sendForMessage(request);
    }

    @Override
    public WebResponse sendAndWait(WebRequest request, WebRequestSettings settings) {
        try {
            request = request.addMetadata("settings", (Object)settings);
            return (WebResponse)this.delegate.sendForMessage(request).get(settings.getTimeout().toMillis() + 1000L, TimeUnit.MILLISECONDS);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("Request %s (url %s) has timed out", request.getMessageId(), WebRequest.getUrl(request.getMetadata())));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GatewayException(String.format("Thread interrupted while waiting for result of %s (url %s)", request.getMessageId(), WebRequest.getUrl(request.getMetadata())), e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @ConstructorProperties(value={"delegate"})
    public DefaultWebRequestGateway(GenericGateway delegate) {
        this.delegate = delegate;
    }

    public void sendAndForget(Object message) {
        this.delegate.sendAndForget(message);
    }

    public void sendAndForget(Object payload, Metadata metadata) {
        this.delegate.sendAndForget(payload, metadata);
    }

    public void sendAndForget(Object payload, Metadata metadata, Guarantee guarantee) {
        this.delegate.sendAndForget(payload, metadata, guarantee);
    }

    public CompletableFuture<Void> sendAndForget(Message message, Guarantee guarantee) {
        return this.delegate.sendAndForget(message, guarantee);
    }

    public void sendAndForget(Object ... messages) {
        this.delegate.sendAndForget(messages);
    }

    public CompletableFuture<Void> sendAndForget(Guarantee guarantee, Object ... messages) {
        return this.delegate.sendAndForget(guarantee, messages);
    }

    public CompletableFuture<Void> sendAndForget(Guarantee guarantee, Message ... messages) {
        return this.delegate.sendAndForget(guarantee, messages);
    }

    public <R> CompletableFuture<R> send(Message message) {
        return this.delegate.send(message);
    }

    public <R> CompletableFuture<R> send(Object message) {
        return this.delegate.send(message);
    }

    public <R> CompletableFuture<R> send(Request<R> message) {
        return this.delegate.send(message);
    }

    public <R> CompletableFuture<R> send(Object payload, Metadata metadata) {
        return this.delegate.send(payload, metadata);
    }

    public <R> CompletableFuture<R> send(Request<R> payload, Metadata metadata) {
        return this.delegate.send(payload, metadata);
    }

    public CompletableFuture<Message> sendForMessage(Message message) {
        return this.delegate.sendForMessage(message);
    }

    public <R> List<CompletableFuture<R>> send(Object ... messages) {
        return this.delegate.send(messages);
    }

    public List<CompletableFuture<Message>> sendForMessages(Message ... messages) {
        return this.delegate.sendForMessages(messages);
    }

    public <R> R sendAndWait(Object message) {
        return this.delegate.sendAndWait(message);
    }

    public <R> R sendAndWait(Request<R> message) {
        return this.delegate.sendAndWait(message);
    }

    public <R> R sendAndWait(Object payload, Metadata metadata) {
        return this.delegate.sendAndWait(payload, metadata);
    }

    public <R> R sendAndWait(Request<R> payload, Metadata metadata) {
        return this.delegate.sendAndWait(payload, metadata);
    }

    public <R> R sendAndWait(Message message) {
        return this.delegate.sendAndWait(message);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.delegate.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.delegate.registerHandler(target, handlerFilter);
    }
}

